/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.tools.StringTools;

public final class MorfologikUkrainianSpellerRule
extends MorfologikSpellerRule {
    private static final String ABBREVIATION_CHAR = ".";
    private static final String RESOURCE_FILENAME = "/uk/hunspell/uk_UA.dict";
    private static final Pattern UKRAINIAN_LETTERS = Pattern.compile(".*[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490].*");
    private static final Pattern DO_NOT_SUGGEST_SPACED_PATTERN = Pattern.compile("(\u0430\u0432\u0456\u0430|\u0430\u0432\u0442\u043e|\u0430\u043d\u0442\u0438|\u0430\u0443\u0434\u0456\u043e|\u0432\u0456\u0434\u0435\u043e|\u0432\u043e\u0434\u043e|\u0433\u0456\u0434\u0440\u043e|\u0435\u043a\u0441\u0442\u0440\u0430|\u043a\u0432\u0430\u0437\u0456|\u043a\u0456\u043d\u043e|\u043b\u0436\u0435|\u043c\u0435\u0442\u0430|\u043c\u043e\u043d\u043e|\u043c\u043e\u0442\u043e|\u043f\u0441\u0435\u0432\u0434\u043e|\u043f\u043e\u0441\u0442|\u0440\u0430\u0434\u0456\u043e|\u0441\u0442\u0435\u0440\u0435\u043e|\u0441\u0443\u043f\u0435\u0440|\u0443\u043b\u044c\u0442\u0440\u0430|\u0444\u043e\u0442\u043e) .*");
    private static final Pattern INFIX_PATTERN = Pattern.compile("-[\u0430-\u044f\u0456\u0457\u0454\u0491]{1,5}-");
    private static final Map<String, String> dashPrefixes2019 = ExtraDictionaryLoader.loadMap("/uk/dash_prefixes.txt");

    public MorfologikUkrainianSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_UK_UA";
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (word.endsWith("-")) {
            return !word.startsWith("-") || !INFIX_PATTERN.matcher(word).matches();
        }
        if (word.endsWith("\u00b2") || word.endsWith("\u00b3")) {
            word = word.substring(0, word.length() - 1);
        }
        return super.isMisspelled(speller, word);
    }

    protected List<SuggestedReplacement> getAdditionalSuggestions(List<SuggestedReplacement> suggestions, String word) {
        boolean isCapitalized = StringTools.isCapitalizedWord((String)word);
        if (isCapitalized) {
            word = word.toLowerCase();
        }
        for (String key : dashPrefixes2019.keySet()) {
            if (!word.startsWith(key) || word.length() <= key.length() + 2 || word.charAt(key.length()) == '-') continue;
            String second = word.substring(key.length());
            suggestions.add(new SuggestedReplacement(key + "-" + second));
        }
        return suggestions;
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        String word = tokens[idx].getToken();
        if (!UKRAINIAN_LETTERS.matcher(word).matches()) {
            return true;
        }
        if (super.ignoreToken(tokens, idx)) {
            return true;
        }
        if (idx < tokens.length - 1 && tokens[idx + 1].getToken().equals(ABBREVIATION_CHAR)) {
            if (super.ignoreWord(word + ABBREVIATION_CHAR)) {
                return true;
            }
            if (word.matches("[\u0410-\u042f\u0406\u0407\u0404\u0490]")) {
                return true;
            }
        }
        return MorfologikUkrainianSpellerRule.hasGoodTag(tokens[idx]);
    }

    private static boolean hasGoodTag(AnalyzedTokenReadings tokens) {
        for (AnalyzedToken analyzedToken : tokens) {
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || posTag.equals("SENT_END") || posTag.equals("PARA_END") || posTag.contains(":inanim") && posTag.contains(":v_kly")) continue;
            return true;
        }
        return false;
    }

    protected List<SuggestedReplacement> filterSuggestions(List<SuggestedReplacement> suggestions) {
        suggestions = super.filterSuggestions(suggestions);
        suggestions.removeIf(item -> item.getReplacement().contains(" ") && DO_NOT_SUGGEST_SPACED_PATTERN.matcher(item.getReplacement()).matches() || item.getReplacement().contains("- "));
        return suggestions;
    }

    MorfologikMultiSpeller getSpeller1() {
        if (this.speller1 == null) {
            try {
                this.isMisspelled("1");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.speller1;
    }

    protected boolean isLatinScript() {
        return false;
    }

    static {
        dashPrefixes2019.entrySet().removeIf(entry -> ((String)entry.getValue()).matches(":(ua_1992|bad|alt|slang)") || !((String)entry.getKey()).matches("[\u0430-\u044f\u0456\u0457\u0454\u0491]{3,}"));
    }
}

