/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.tagging.uk.PosTagHelper;

public class SimpleReplaceRenamedRule
extends Rule {
    private static final Map<String, List<String>> RENAMED_LIST = ExtraDictionaryLoader.loadLists("/uk/replace_renamed.txt");
    private static final Pattern GEO_POSTAG_PATTERN = Pattern.compile("noun:inanim.*?:prop.*|adj.*");

    public SimpleReplaceRenamedRule(ResourceBundle messages) {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE_RENAMED";
    }

    public String getDescription() {
        return "\u041f\u0440\u043e\u043f\u043e\u0437\u0438\u0446\u0456\u044f \u043f\u043e\u0442\u043e\u0447\u043d\u043e\u0457 \u043d\u0430\u0437\u0432\u0438 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0445 \u0432\u043b\u0430\u0441\u043d\u0438\u0445 \u043d\u0430\u0437\u0432";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            LinkedHashSet<Object> renamedLemmas = new LinkedHashSet<Object>();
            for (AnalyzedToken reading : tokenReadings.getReadings()) {
                String lemma = reading.getLemma();
                if ("SENT_END".equals(reading.getPOSTag()) || lemma == null) continue;
                if (RENAMED_LIST.containsKey(lemma) && PosTagHelper.hasPosTag(reading, GEO_POSTAG_PATTERN)) {
                    renamedLemmas.add(lemma);
                    continue;
                }
                renamedLemmas.clear();
                break;
            }
            if (renamedLemmas.size() <= 0) continue;
            String info = "";
            ArrayList<String> replacements = new ArrayList<String>();
            for (String string : renamedLemmas) {
                List<String> repl = RENAMED_LIST.get(string);
                replacements.add(repl.get(0));
                for (int i = 1; i < repl.size() - 1; ++i) {
                    replacements.add(repl.get(i));
                }
                if (!info.isEmpty() || repl.size() <= 1) continue;
                info = repl.get(repl.size() - 1);
            }
            RuleMatch match = this.createRuleMatch(tokenReadings, replacements, this.getMessage((String)renamedLemmas.iterator().next(), info), sentence);
            ruleMatches.add(match);
        }
        return ruleMatches.toArray(new RuleMatch[0]);
    }

    private String getMessage(String tokenStr, String info) {
        String msg = "\u00ab" + tokenStr + "\u00bb \u0431\u0443\u043b\u043e \u043f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043e";
        if (!info.isEmpty()) {
            msg = msg + " (" + info + ")";
        }
        return msg;
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings readings, List<String> replacements, String msg, AnalyzedSentence sentence) {
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, readings.getStartPos(), readings.getEndPos(), msg, "\u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0430 \u043d\u0430\u0437\u0432\u0430");
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }
}

