/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RussianVerbConjugationRule
extends Rule {
    private static final Pattern PRONOUN = Pattern.compile("PNN:(.*):Nom:(.*)");
    private static final Pattern FUT_REAL_VERB = Pattern.compile("VB:(Fut|Real):(.*):(.*):(.*):(.*)");
    private static final Pattern PAST_VERB = Pattern.compile("VB:Past:(.*):(.*):(.*)");

    public RussianVerbConjugationRule(ResourceBundle messages) {
        super(messages);
    }

    public String getId() {
        return "RU_VERB_CONJUGATION";
    }

    public String getDescription() {
        return "\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435 \u043b\u0438\u0447\u043d\u044b\u0445 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u0439 \u0441 \u0433\u043b\u0430\u0433\u043e\u043b\u0430\u043c\u0438";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokenReadings = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokenReadings.length - 1; ++i) {
            Matcher pronounMatcher;
            AnalyzedTokenReadings currentReading = tokenReadings[i];
            AnalyzedTokenReadings nextReading = tokenReadings[i + 1];
            AnalyzedToken currentLemmaTok = (AnalyzedToken)currentReading.getReadings().get(0);
            String currentToken = currentLemmaTok.getToken();
            String currentPosTag = currentLemmaTok.getPOSTag();
            if (currentToken == null || currentPosTag == null || currentToken.isEmpty() || currentPosTag.isEmpty() || !(pronounMatcher = PRONOUN.matcher(currentPosTag)).find()) continue;
            ImmutablePair pronounPair = new ImmutablePair((Object)pronounMatcher.group(1), (Object)pronounMatcher.group(2));
            AnalyzedToken nextLemmaTok = (AnalyzedToken)nextReading.getReadings().get(0);
            String nextPosTag = nextLemmaTok.getPOSTag();
            if (nextPosTag == null || nextPosTag.isEmpty()) continue;
            Matcher verbMatcher = FUT_REAL_VERB.matcher(nextPosTag);
            if (verbMatcher.find()) {
                ImmutablePair verbPair = new ImmutablePair((Object)verbMatcher.group(4), (Object)verbMatcher.group(5));
                if (!this.isConjugationInPresentOrFutureWrong((Pair<String, String>)pronounPair, (Pair<String, String>)verbPair)) continue;
                this.addRuleMatch(ruleMatches, currentReading, nextReading, sentence);
                continue;
            }
            verbMatcher = PAST_VERB.matcher(nextPosTag);
            if (!verbMatcher.find() || !this.isConjugationInPastWrong(pronounMatcher.group(1), verbMatcher.group(3))) continue;
            this.addRuleMatch(ruleMatches, currentReading, nextReading, sentence);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isConjugationInPresentOrFutureWrong(Pair<String, String> pronoun, Pair<String, String> verb) {
        if (!((String)pronoun.getRight()).equals(verb.getRight())) {
            return true;
        }
        if (Arrays.asList("Masc", "Fem", "Neut").contains(pronoun.getLeft())) {
            return "PL".equals(verb.getLeft());
        }
        return !((String)pronoun.getLeft()).equals(verb.getLeft());
    }

    private boolean isConjugationInPastWrong(String pronoun, String verb) {
        if ("Sin".equals(pronoun)) {
            return "PL".equals(verb) || "Neut".equals(verb);
        }
        return !pronoun.equals(verb);
    }

    private void addRuleMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings currentReading, AnalyzedTokenReadings nextReading, AnalyzedSentence sentence) {
        RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, currentReading.getStartPos(), nextReading.getEndPos(), "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0441\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u0430 \u0438\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u0435", this.getShort());
        ruleMatches.add(ruleMatch);
    }

    protected String getShort() {
        return "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0441\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u0430";
    }
}

