/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.WordCoherencyDataLoader;

public class PortugueseWordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/pt/coherency.txt");

    public PortugueseWordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Inconsistency);
        this.addExamplePair(Example.wrong((String)"Foi um per\u00edodo duradouro. T\u00e3o marcante e <marker>duradoiro</marker> dificilmente ser\u00e1 esquecido."), Example.fixed((String)"Foi um per\u00edodo duradouro. T\u00e3o marcante e <marker>duradouro</marker> dificilmente ser\u00e1 esquecido."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "N\u00e3o deve utilizar formas distintas de palavras com dupla grafia no mesmo texto. Escolha entre '" + word1 + "' e '" + word2 + "'.";
    }

    public String getId() {
        return "PT_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Consist\u00eancia de palavras com grafias m\u00faltiplas";
    }
}

