/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikPolishSpellerRule
extends MorfologikSpellerRule {
    private static final String RESOURCE_FILENAME = "/pl/hunspell/pl_PL.dict";
    private static final Pattern POLISH_TOKENIZING_CHARS = Pattern.compile("(?:[Qq]uasi|[Nn]iby)-");
    private static final Set<String> prefixes;
    private static final Set<String> bannedSuffixes;

    public MorfologikPolishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"To jest zdanie z <marker>bledem</marker>"), Example.fixed((String)"To jest zdanie z <marker>b\u0142\u0119dem</marker>."));
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_PL_PL";
    }

    public Pattern tokenizingPattern() {
        return POLISH_TOKENIZING_CHARS;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.isMisspelled(this.speller1, word) && this.isNotCompound(word)) {
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            if (!this.isMisspelled(this.speller1, word.toLowerCase(this.conversionLocale))) {
                List<String> suggestion = Arrays.asList(word.toLowerCase(this.conversionLocale));
                ruleMatch.setSuggestedReplacements(suggestion);
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
            List suggestions = this.speller1.getSuggestions(word);
            suggestions.addAll(0, this.getAdditionalTopSuggestions(suggestions, word));
            suggestions.addAll(this.getAdditionalSuggestions(suggestions, word));
            if (!suggestions.isEmpty()) {
                ruleMatch.setSuggestedReplacements(this.pruneSuggestions(this.orderSuggestions(suggestions, word)));
            }
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    private boolean isNotCompound(String word) throws IOException {
        ArrayList<String> probablyCorrectWords = new ArrayList<String>();
        ArrayList<String> testedTokens = new ArrayList<String>(2);
        for (int i = 2; i < word.length(); ++i) {
            String first = word.substring(0, i);
            String second = word.substring(i, word.length());
            if (prefixes.contains(first.toLowerCase(this.conversionLocale)) && !this.isMisspelled(this.speller1, second) && second.length() > first.length()) {
                probablyCorrectWords.add(word);
                continue;
            }
            testedTokens.clear();
            testedTokens.add(first);
            testedTokens.add(second);
            List taggedToks = this.language.getTagger().tag(testedTokens);
            if (taggedToks.size() != 2 || !((AnalyzedTokenReadings)taggedToks.get(0)).hasPosTag("adja") && (!((AnalyzedTokenReadings)taggedToks.get(0)).hasPosTag("num:comp") || ((AnalyzedTokenReadings)taggedToks.get(0)).hasPosTag("adv")) || !((AnalyzedTokenReadings)taggedToks.get(1)).hasPartialPosTag("adj:")) continue;
            probablyCorrectWords.add(word);
        }
        if (!probablyCorrectWords.isEmpty()) {
            this.addIgnoreTokens(probablyCorrectWords);
            return false;
        }
        return true;
    }

    private List<String> pruneSuggestions(List<String> suggestions) {
        ArrayList<String> prunedSuggestions = new ArrayList<String>(suggestions.size());
        for (String suggestion : suggestions) {
            if (suggestion.indexOf(32) == -1) {
                prunedSuggestions.add(suggestion);
                continue;
            }
            String[] complexSug = suggestion.split(" ");
            if (bannedSuffixes.contains(complexSug[1])) continue;
            prunedSuggestions.add(suggestion);
        }
        return prunedSuggestions;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("arcy");
        tempSet.add("neo");
        tempSet.add("pre");
        tempSet.add("anty");
        tempSet.add("eks");
        tempSet.add("bez");
        tempSet.add("beze");
        tempSet.add("ekstra");
        tempSet.add("hiper");
        tempSet.add("infra");
        tempSet.add("kontr");
        tempSet.add("maksi");
        tempSet.add("midi");
        tempSet.add("mi\u0119dzy");
        tempSet.add("mini");
        tempSet.add("nad");
        tempSet.add("nade");
        tempSet.add("oko\u0142o");
        tempSet.add("ponad");
        tempSet.add("post");
        tempSet.add("pro");
        tempSet.add("przeciw");
        tempSet.add("pseudo");
        tempSet.add("super");
        tempSet.add("\u015br\u00f3d");
        tempSet.add("ultra");
        tempSet.add("wice");
        tempSet.add("wok\u00f3\u0142");
        tempSet.add("woko\u0142o");
        prefixes = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet();
        tempSet.add("ami");
        tempSet.add("ach");
        tempSet.add("e");
        tempSet.add("ego");
        tempSet.add("em");
        tempSet.add("emu");
        tempSet.add("ie");
        tempSet.add("im");
        tempSet.add("m");
        tempSet.add("om");
        tempSet.add("owie");
        tempSet.add("owi");
        tempSet.add("ze");
        bannedSuffixes = Collections.unmodifiableSet(tempSet);
    }
}

