/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.GlobalConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrammalecteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(GrammalecteRule.class);
    private static final int TIMEOUT_MILLIS = 500;
    private static final long DOWN_INTERVAL_MILLISECONDS = 5000L;
    private static long lastRequestError = 0L;
    private final ObjectMapper mapper = new ObjectMapper();
    private final GlobalConfig globalConfig;
    private final Set<String> ignoreRules = new HashSet<String>(Arrays.asList("tab_fin_ligne", "apostrophe_typographique", "typo_guillemets_typographiques_doubles_ouvrants", "nbsp_avant_double_ponctuation", "typo_guillemets_typographiques_doubles_fermants", "nbsp_avant_deux_points", "nbsp_ajout_avant_double_ponctuation", "apostrophe_typographique_apr\u00e8s_t", "typo_tiret_d\u00e9but_ligne", "typo_guillemets_typographiques_simples_fermants", "typo_apostrophe_incorrecte", "unit_nbsp_avant_unit\u00e9s1", "unit_nbsp_avant_unit\u00e9s2", "unit_nbsp_avant_unit\u00e9s3", "nbsp_apr\u00e8s_double_ponctuation", "typo_guillemets_typographiques_simples_ouvrants", "num_grand_nombre_avec_espaces", "num_grand_nombre_soud\u00e9", "typo_parenth\u00e8se_ouvrante_coll\u00e9e", "nbsp_apr\u00e8s_chevrons_ouvrants", "nbsp_avant_chevrons_fermants", "nbsp_avant_chevrons_fermants1", "nbsp_avant_chevrons_fermants2", "typo_points_suspension1", "typo_points_suspension2", "typo_points_suspension3", "typo_tiret_incise", "esp_avant_apr\u00e8s_tiret", "nbsp_apr\u00e8s_tiret1", "nbsp_apr\u00e8s_tiret2", "esp_m\u00e9lang\u00e9s1", "esp_m\u00e9lang\u00e9s2", "tab_d\u00e9but_ligne", "esp_milieu_ligne", "typo_ponctuation_superflue1", "esp_ins\u00e9cables_multiples", "typo_espace_manquant_apr\u00e8s1", "typo_espace_manquant_apr\u00e8s2", "typo_espace_manquant_apr\u00e8s3", "typo_tiret_incise2", "eepi_\u00e9criture_\u00e9pic\u00e8ne_singulier", "g1__eleu_\u00e9lisions_manquantes__b1_a1_1"));

    public GrammalecteRule(ResourceBundle messages, GlobalConfig globalConfig) {
        super(messages);
        this.globalConfig = globalConfig;
    }

    public String getId() {
        return "FR_GRAMMALECTE";
    }

    public String getDescription() {
        return "Returns matches of a local Grammalecte server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        Object encoded;
        if (System.currentTimeMillis() - lastRequestError < 5000L) {
            logger.warn("Warn: Temporarily disabled Grammalecte server because of recent error.");
            return new RuleMatch[0];
        }
        URL serverUrl = new URL(this.globalConfig.getGrammalecteServer());
        HttpURLConnection huc = (HttpURLConnection)serverUrl.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        huc.setConnectTimeout(500);
        huc.setReadTimeout(1000);
        if (this.globalConfig.getGrammalecteUser() != null && this.globalConfig.getGrammalectePassword() != null) {
            String authString = this.globalConfig.getGrammalecteUser() + ":" + this.globalConfig.getGrammalectePassword();
            encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            huc.setRequestProperty("Authorization", "Basic " + (String)encoded);
        }
        huc.setRequestMethod("POST");
        huc.setDoOutput(true);
        try {
            huc.connect();
            DataOutputStream wr = new DataOutputStream(huc.getOutputStream());
            encoded = null;
            try {
                String urlParameters = "text=" + this.encode(sentence.getText());
                byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
                wr.write(postData);
            }
            catch (Throwable throwable) {
                encoded = throwable;
                throw throwable;
            }
            finally {
                if (wr != null) {
                    if (encoded != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)encoded).addSuppressed(throwable);
                        }
                    } else {
                        wr.close();
                    }
                }
            }
            InputStream input = huc.getInputStream();
            List<RuleMatch> ruleMatches = this.parseJson(input);
            RuleMatch[] ruleMatchArray = this.toRuleMatchArray(ruleMatches);
            return ruleMatchArray;
        }
        catch (Exception e) {
            lastRequestError = System.currentTimeMillis();
            logger.warn("Warn: Failed to query Grammalecte server at " + serverUrl + ": " + e.getClass() + ": " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            huc.disconnect();
        }
        return new RuleMatch[0];
    }

    @NotNull
    private List<RuleMatch> parseJson(InputStream inputStream) throws IOException {
        Map map = (Map)this.mapper.readValue(inputStream, Map.class);
        ArrayList matches = (ArrayList)map.get("data");
        if (matches == null) {
            throw new RuntimeException("No 'data' found in grammalecte JSON: " + map);
        }
        ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
        for (Object match : matches) {
            List<RuleMatch> remoteMatches = this.getMatches((Map)match);
            result.addAll(remoteMatches);
        }
        return result;
    }

    protected String encode(String plainText) throws UnsupportedEncodingException {
        return URLEncoder.encode(plainText, StandardCharsets.UTF_8.name());
    }

    @NotNull
    private List<RuleMatch> getMatches(Map<String, Object> match) {
        ArrayList<RuleMatch> remoteMatches = new ArrayList<RuleMatch>();
        ArrayList matches = (ArrayList)match.get("lGrammarErrors");
        for (Object o : matches) {
            Map pairs = (Map)o;
            int offset = (Integer)pairs.get("nStart");
            int endOffset = (Integer)pairs.get("nEnd");
            String id = (String)pairs.get("sRuleId");
            if (this.ignoreRules.contains(id)) continue;
            String message = pairs.get("sMessage").toString();
            GrammalecteInternalRule rule = new GrammalecteInternalRule("grammalecte_" + id, message);
            RuleMatch extMatch = new RuleMatch((Rule)rule, null, offset, endOffset, message);
            List suggestions = (List)pairs.get("aSuggestions");
            extMatch.setSuggestedReplacements(suggestions);
            remoteMatches.add(extMatch);
        }
        return remoteMatches;
    }

    static class GrammalecteInternalRule
    extends Rule {
        private final String id;
        private final String desc;

        GrammalecteInternalRule(String id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.desc;
        }

        public RuleMatch[] match(AnalyzedSentence sentence) {
            throw new RuntimeException("Not implemented");
        }
    }
}

