/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tools.StringTools;

public class MorfologikSpanishSpellerRule
extends MorfologikSpellerRule {
    private static final List<String> REMOVE_FROM_SUGGESTIONS = Arrays.asList("abu", "abue", "abus", "anarco", "anarcos", "arbi", "arbis", "arqui", "arquis", "Barna", "bibe", "bibes", "biblio", "biblios", "bolche", "bolches", "cami", "camis", "capi", "capis", "celu", "celus", "ceni", "cenis", "cerve", "cerves", "chiqui", "chiquis", "chuche", "chuches", "chumi", "chumis", "cintu", "cintus", "comi", "comis", "compu", "compus", "confe", "confes", "confi", "confis", "conge", "conges", "copi", "copis", "cosquis", "coti", "cotis", "c\u00edber", "deco", "decos", "deli", "delis", "depa", "depas", "d\u00edver", "facu", "facus", "festi", "festis", "frigo", "frigos", "f\u00e1cul", "gili", "gilis", "gine", "gineco", "ginecos", "gines", "Gran\u00e1", "hospi", "hospis", "ilu", "ilus", "impeque", "impeques", "inge", "inges", "joputa", "joputas", "jueputa", "jueputas", "lesbi", "lesbis", "lipo", "lipos", "lito", "litos", "mani", "manifa", "manifas", "manis", "mari", "maris", "masoca", "masocas", "milqui", "milquis", "munipa", "munipas", "ofi", "ofis", "pandi", "pandis", "pasti", "pastis", "pelu", "pelus", "pendeviejo", "pendeviejos", "peni", "penis", "pisci", "piscis", "piti", "pitis", "porfapl\u00eds", "porfi", "porfipl\u00eds", "porfis", "porsi", "porsiaca", "porsiacas", "porsis", "prefe", "prefes", "prince", "princes", "pringui", "pringuis", "prosti", "prostis", "prota", "protas", "prote", "protes", "psico", "psicos", "psiqui", "psiquis", "publi", "publis", "puti", "putis", "quillo", "quillos", "refri", "refris", "regu", "regus", "repe", "repes", "resi", "resis", "ridi", "ridis", "rotu", "rotus", "sado", "sados", "soco", "socos", "sufi", "sufis", "suje", "sujes", "tatu", "tatus", "torti", "tortis", "tranqui", "tranquis", "trici", "tricis", "ulti", "ultis", "urba", "urbas", "vice", "vices", "vitro", "vitros", "\u00f1ero", "\u00f1eros");
    private static final List<String> PREFIX_WITH_WHITESPACE = Arrays.asList("ultra", "eco", "tele", "anti", "auto", "ex", "extra", "macro", "mega", "meta", "micro", "multi", "mono", "mini", "post", "retro", "semi", "super", "hiper", "trans", "re", "g", "l", "m");
    private static final List<String> PRONOMBRE_INICIAL = Arrays.asList("me", "te", "se", "nos", "os", "lo", "le", "la", "los", "las");
    private static final Pattern CAMEL_CASE = Pattern.compile("^(.\\p{Ll}+)(\\p{Lu}.+)$", 64);
    private static final List<String> PARTICULA_FINAL = Arrays.asList("que", "cual");
    private static final List<String> SPLIT_DIGITS_AT_END = Arrays.asList("en", "de", "del", "al", "a", "y", "o", "con");
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V.[SI].*");
    private static final SpanishTagger tagger = SpanishTagger.INSTANCE;

    public MorfologikSpanishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
    }

    public String getFileName() {
        return "/es/es-ES.dict";
    }

    public final String getId() {
        return "MORFOLOGIK_RULE_ES";
    }

    public boolean useInOffice() {
        return true;
    }

    public List<String> getAdditionalSpellingFileNames() {
        return Arrays.asList("/es//hunspell/spelling_custom.txt", "spelling_global.txt", "/es/multiwords.txt");
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        String wordWithouDiacriticsString = StringTools.removeDiacritics((String)word);
        for (int i = 0; i < suggestions.size(); ++i) {
            int posNewSugg;
            String replacement = suggestions.get(i).getReplacement().toLowerCase();
            if (REMOVE_FROM_SUGGESTIONS.contains(replacement)) continue;
            String[] parts = replacement.split(" ");
            for (posNewSugg = 0; newSuggestions.size() > posNewSugg && StringTools.removeDiacritics((String)((SuggestedReplacement)newSuggestions.get(posNewSugg)).getReplacement()).equalsIgnoreCase(wordWithouDiacriticsString); ++posNewSugg) {
            }
            if (parts.length == 2) {
                String newSuggestion;
                List<AnalyzedTokenReadings> atkn;
                if (parts[1].equals("s") || PREFIX_WITH_WHITESPACE.contains(parts[0])) continue;
                if (parts[1].length() > 1 && PRONOMBRE_INICIAL.contains(parts[0].toLowerCase()) && (atkn = tagger.tag(Arrays.asList(newSuggestion = parts[1]))).get(0).matchesPosTagRegex(VERB_INDSUBJ)) {
                    newSuggestions.add(posNewSugg, suggestions.get(i));
                    continue;
                }
                if (PARTICULA_FINAL.contains(parts[1])) {
                    newSuggestions.add(0, suggestions.get(i));
                    continue;
                }
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        CharSequence[] parts = StringTools.splitCamelCase((String)word);
        if (parts.length > 1) {
            boolean isNotMisspelled = true;
            for (String string : parts) {
                isNotMisspelled &= !this.speller1.isMisspelled(string);
            }
            if (isNotMisspelled) {
                return Collections.singletonList(String.join((CharSequence)" ", parts));
            }
        }
        if ((parts = StringTools.splitDigitsAtEnd((String)word)).length > 1 && tagger.tag(Arrays.asList(parts[0])).get(0).isTagged() && (((String)parts[0]).length() > 2 || SPLIT_DIGITS_AT_END.contains(((String)parts[0]).toLowerCase()))) {
            return Collections.singletonList(String.join((CharSequence)" ", parts));
        }
        return Collections.emptyList();
    }

    protected boolean tokenizeNewWords() {
        return false;
    }
}

