/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SpellingData;

public class OldSpellingRule
extends Rule {
    private static final String FILE_PATH = "/de/alt_neu.csv";
    private static final List<String> exceptions = Arrays.asList("Schlo\u00df Holte");
    private static final SpellingData DATA = new SpellingData("/de/alt_neu.csv");

    public OldSpellingRule(ResourceBundle messages) {
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"Der <marker>Abflu\u00df</marker> ist schon wieder verstopft."), Example.fixed((String)"Der <marker>Abfluss</marker> ist schon wieder verstopft."));
    }

    public String getId() {
        return "OLD_SPELLING";
    }

    public String getDescription() {
        return "Findet Schreibweisen, die nur in der alten Rechtschreibung g\u00fcltig waren";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text = sentence.getText();
        List hits = DATA.getTrie().parseText((CharSequence)text);
        HashSet<Integer> startPositions = new HashSet<Integer>();
        Collections.reverse(hits);
        for (AhoCorasickDoubleArrayTrie.Hit hit : hits) {
            if (startPositions.contains(hit.begin)) continue;
            boolean ignore = false;
            for (String exception : exceptions) {
                String excCovered;
                if (hit.begin + exception.length() > text.length() || !(excCovered = text.substring(hit.begin, hit.begin + exception.length())).equals(exception)) continue;
                ignore = true;
                break;
            }
            if (hit.begin > 0 && !this.isBoundary(text.substring(hit.begin - 1, hit.begin))) {
                ignore = true;
            }
            if (hit.end < text.length() && !this.isBoundary(text.substring(hit.end, hit.end + 1))) {
                ignore = true;
            }
            if (ignore) continue;
            RuleMatch match = new RuleMatch((Rule)this, sentence, hit.begin, hit.end, "Diese Schreibweise war nur in der alten Rechtschreibung korrekt.", "alte Rechtschreibung");
            String[] suggestions = ((String)hit.value).split("\\|");
            match.setSuggestedReplacements(Arrays.asList(suggestions));
            matches.add(match);
            startPositions.add(hit.begin);
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean isBoundary(String s) {
        return !s.matches("[a-zA-Z\u00f6\u00e4\u00fc\u00df]");
    }
}

