/*
 * Decompiled with CFR 0.152.
 */
package org.lable.lapin.maven;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;

public class LocalHbaseManager {
    private volatile HbaseRunner hbaseThread;

    public void start() throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            System.setProperty("test.build.data.basedirectory", "C:/Temp/hbase");
        }
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", 33533);
        htu.startMiniCluster();
        htu.getAdmin().createNamespace(NamespaceDescriptor.create((String)"test").build());
        this.hbaseThread = new HbaseRunner(htu);
        this.hbaseThread.setDaemon(true);
        this.hbaseThread.start();
    }

    public void stop() {
        this.hbaseThread.terminate();
    }

    static class HbaseRunner
    extends Thread {
        private final HBaseTestingUtility htu;
        private volatile boolean shouldRun = true;

        public HbaseRunner(HBaseTestingUtility htu) {
            this.htu = htu;
        }

        @Override
        public void run() {
            while (this.shouldRun) {
                Thread.onSpinWait();
            }
        }

        public void terminate() {
            try {
                this.htu.shutdownMiniCluster();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("STOPPING");
            this.shouldRun = false;
        }
    }
}

