/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kew.workgroup.GroupId;
import org.kuali.rice.kew.workgroup.GroupNameId;
import org.kuali.rice.kim.api.group.Group;
import org.w3c.dom.Element;

public class WorkgroupWorkflowEDLConfigComponent
extends SimpleWorkflowEDLConfigComponent {
    private boolean required = false;

    protected GroupId resolveId(String id) {
        String groupName = Utilities.parseGroupName((String)id);
        String namespace = Utilities.parseGroupNamespaceCode((String)id);
        return new GroupNameId(namespace, groupName);
    }

    @Override
    public Element getReplacementConfigElement(Element element) {
        Element replacementEl = (Element)element.cloneNode(true);
        Element type = (Element)replacementEl.getElementsByTagName("type").item(0);
        type.setTextContent("text");
        Element validation = (Element)replacementEl.getElementsByTagName("validation").item(0);
        if (validation != null && validation.getAttribute("required").equals("true")) {
            this.required = true;
        }
        return replacementEl;
    }

    @Override
    public String getErrorMessage(Element originalConfigElement, RequestParser requestParser, MatchingParam param) {
        if (param.getParamValue().length() == 0 && this.required) {
            return "Workgroup is a required field";
        }
        if (param.getParamValue().length() == 0 && !this.required) {
            return null;
        }
        String wrkgrpName = param.getParamValue();
        Group group = KEWServiceLocator.getIdentityHelperService().getGroup(this.resolveId(wrkgrpName));
        if (group == null) {
            return "Group " + wrkgrpName + " not found.";
        }
        if (!group.isActive()) {
            return "Group " + wrkgrpName + " is not an active group.";
        }
        return null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

