/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

public class UserAction {
    public static final String ACTION_CREATE = "initiate";
    public static final String ACTION_LOAD = "load";
    public static final String ACTION_UNDEFINED = "undefined";
    public static final String ACTION_ROUTE = "route";
    public static final String ACTION_APPROVE = "approve";
    public static final String ACTION_DISAPPROVE = "disapprove";
    public static final String ACTION_CANCEL = "cancel";
    public static final String ACTION_BLANKETAPPROVE = "blanketApprove";
    public static final String ACTION_FYI = "fyi";
    public static final String ACTION_ACKNOWLEDGE = "acknowledge";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_COMPLETE = "complete";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_RETURN_TO_PREVIOUS = "returnToPrevious";
    public static final String ACTION_REFRESH_FROM_LOOKUP = "refresh";
    public static final String ACTION_CREATE_LABEL = "initiate";
    public static final String ACTION_LOAD_LABEL = "load";
    public static final String ACTION_ROUTE_LABEL = "submit";
    public static final String ACTION_APPROVE_LABEL = "approve";
    public static final String ACTION_DISAPPROVE_LABEL = "disapprove";
    public static final String ACTION_CANCEL_LABEL = "cancel";
    public static final String ACTION_BLANKETAPPROVE_LABEL = "blanket approve";
    public static final String ACTION_FYI_LABEL = "fyi";
    public static final String ACTION_ACKNOWLEDGE_LABEL = "acknowledge";
    public static final String ACTION_SAVE_LABEL = "save";
    public static final String ACTION_COMPLETE_LABEL = "complete";
    public static final String ACTION_DELETE_LABEL = "delete";
    public static final String ACTION_RETURN_TO_PREVIOUS_LABEL = "return to previous";
    public static final String ACTION_REFRESH_FROM_LOOKUP_LABEL = "refresh";
    public static final String[] LOAD_ACTIONS = new String[]{"load", "initiate"};
    public static final String[] REPLACE_VERSION_ACTIONS = new String[]{"undefined"};
    public static final String[] VALIDATABLE_ACTIONS = new String[]{"save", "route", "approve", "acknowledge", "complete", "fyi", "disapprove", "returnToPrevious"};
    public static final String[] ANNOTATABLE_ACTIONS = new String[]{"approve", "acknowledge", "complete", "fyi", "disapprove", "cancel", "returnToPrevious"};
    public static final String[] EDITABLE_ACTIONS = new String[]{"initiate", "route", "approve", "disapprove", "complete"};
    private String action;

    public UserAction(String action) {
        this.action = action.equals("initiate") ? "initiate" : (action.equals("load") ? "load" : (action.equals(ACTION_ROUTE_LABEL) ? ACTION_ROUTE : (action.equals("approve") ? "approve" : (action.equals("disapprove") ? "disapprove" : (action.equals("cancel") ? "cancel" : (action.equals(ACTION_BLANKETAPPROVE_LABEL) ? ACTION_BLANKETAPPROVE : (action.equals("fyi") ? "fyi" : (action.equals("acknowledge") ? "acknowledge" : (action.equals("save") ? "save" : (action.equals("complete") ? "complete" : (action.equals("delete") ? "delete" : (action.equals(ACTION_RETURN_TO_PREVIOUS_LABEL) ? ACTION_RETURN_TO_PREVIOUS : (action.equals("refresh") ? "refresh" : action)))))))))))));
    }

    public String getAction() {
        return this.action;
    }

    public boolean isLoadAction() {
        return this.containsAction(LOAD_ACTIONS, this.action);
    }

    public boolean isIncrementVersionAction() {
        return !this.isLoadAction() && !this.isReplaceVersionAction() && !"refresh".equals(this.action);
    }

    public boolean isReplaceVersionAction() {
        return this.containsAction(REPLACE_VERSION_ACTIONS, this.action);
    }

    public boolean isValidatableAction() {
        return this.containsAction(VALIDATABLE_ACTIONS, this.action);
    }

    public boolean isAnnotatableAction() {
        return this.containsAction(ANNOTATABLE_ACTIONS, this.action);
    }

    public boolean isEditableAction() {
        return this.containsAction(EDITABLE_ACTIONS, this.action);
    }

    private boolean containsAction(String[] actions, String action) {
        for (int index = 0; index < actions.length; ++index) {
            if (!actions[index].equals(action)) continue;
            return true;
        }
        return false;
    }
}

