/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.UserAction;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorkflowDocumentState
implements EDLModelComponent {
    private static final Logger LOG = Logger.getLogger(WorkflowDocumentState.class);

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        try {
            Element documentState = EDLXmlUtils.getDocumentStateElement(dom);
            Element dateTime = EDLXmlUtils.getOrCreateChildElement(documentState, "dateTime", true);
            dateTime.appendChild(dom.createTextNode(RiceConstants.getDefaultDateAndTimeFormat().format(new Date())));
            Element definition = EDLXmlUtils.getOrCreateChildElement(documentState, "definition", true);
            definition.appendChild(dom.createTextNode(edlContext.getEdocLiteAssociation().getDefinition()));
            Element docType = EDLXmlUtils.getOrCreateChildElement(documentState, "docType", true);
            docType.appendChild(dom.createTextNode(edlContext.getEdocLiteAssociation().getEdlName()));
            Element style = EDLXmlUtils.getOrCreateChildElement(documentState, "style", true);
            String styleName = edlContext.getEdocLiteAssociation().getStyle();
            if (styleName == null) {
                styleName = "Default";
            }
            style.appendChild(dom.createTextNode(styleName));
            Element showAttachments = EDLXmlUtils.getOrCreateChildElement(documentState, "showAttachments", true);
            boolean showConstants = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "All", "SHOW_ATTACHMENTS_IND");
            showAttachments.appendChild(dom.createTextNode(Boolean.valueOf(showConstants).toString()));
            WorkflowDocument document = (WorkflowDocument)edlContext.getRequestParser().getAttribute("workflowDocument");
            boolean documentEditable = false;
            if (document != null) {
                List<String> validActions = WorkflowDocumentState.determineValidActions(document);
                documentEditable = WorkflowDocumentState.isEditable(edlContext, validActions);
                edlContext.getTransformer().setParameter("readOnly", String.valueOf(documentEditable));
                WorkflowDocumentState.addActions(dom, documentState, validActions);
                boolean isAnnotatable = WorkflowDocumentState.isAnnotatable(validActions);
                EDLXmlUtils.createTextElementOnParent(documentState, "annotatable", String.valueOf(isAnnotatable));
                EDLXmlUtils.createTextElementOnParent(documentState, "docId", document.getDocumentId());
                Element workflowDocumentStatus = EDLXmlUtils.getOrCreateChildElement(documentState, "workflowDocumentState", true);
                EDLXmlUtils.createTextElementOnParent(workflowDocumentStatus, "status", document.getStatus().getLabel());
                EDLXmlUtils.createTextElementOnParent(workflowDocumentStatus, "createDate", RiceConstants.getDefaultDateAndTimeFormat().format(document.getDateCreated().toDate()));
                List nodeNames = document.getPreviousNodeNames();
                if (nodeNames.size() > 0) {
                    Element previousNodes = EDLXmlUtils.getOrCreateChildElement(documentState, "previousNodes", true);
                    for (int i = 0; i < nodeNames.size(); ++i) {
                        EDLXmlUtils.createTextElementOnParent(previousNodes, "node", (String)nodeNames.get(i));
                    }
                }
                List routeNodeInstances = KewApiServiceLocator.getWorkflowDocumentService().getCurrentRouteNodeInstances(document.getDocumentId());
                for (RouteNodeInstance currentNode : routeNodeInstances) {
                    EDLXmlUtils.createTextElementOnParent(documentState, "currentNodeName", currentNode.getName());
                }
            }
            Element editable = EDLXmlUtils.getOrCreateChildElement(documentState, "editable", true);
            editable.appendChild(dom.createTextNode(String.valueOf(documentEditable)));
            EDLXmlUtils.createTextElementOnParent(documentState, "actionable", "true");
            List globalErrors = (List)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalErrors");
            List globalMessages = (List)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalMessages");
            Map globalFieldErrors = (Map)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalFieldErrors");
            EDLXmlUtils.addErrorsAndMessagesToDocument(dom, globalErrors, globalMessages, globalFieldErrors);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Transforming dom " + XmlJotter.jotNode((Node)dom, (boolean)true)));
            }
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    public static List<String> determineValidActions(WorkflowDocument wfdoc) throws WorkflowException {
        String[] flags = new String[10];
        ArrayList<String> list = new ArrayList<String>();
        if (wfdoc == null) {
            list.add("initiate");
            return list;
        }
        if (wfdoc.isAcknowledgeRequested()) {
            flags[buttons.ACKNOWLEDGE.ordinal()] = "acknowledge";
        }
        if (wfdoc.isApprovalRequested()) {
            if (wfdoc.isBlanketApproveCapable()) {
                flags[buttons.BLANKETAPPROVE.ordinal()] = "blanketApprove";
            }
            if (!wfdoc.isSaved()) {
                flags[buttons.APPROVE.ordinal()] = "approve";
                flags[buttons.DISAPPROVE.ordinal()] = "disapprove";
            }
            flags[buttons.SAVE.ordinal()] = "save";
            if (wfdoc.getPreviousNodeNames().size() > 0) {
                flags[buttons.RETURNTOPREVIOUS.ordinal()] = "returnToPrevious";
            }
        } else if (wfdoc.isCompletionRequested()) {
            flags[buttons.COMPLETE.ordinal()] = "complete";
            if (wfdoc.isBlanketApproveCapable()) {
                flags[buttons.BLANKETAPPROVE.ordinal()] = "blanketApprove";
            }
        }
        if (wfdoc.isFYIRequested()) {
            flags[buttons.FYI.ordinal()] = "fyi";
        }
        if (wfdoc.isRouteCapable()) {
            flags[buttons.ROUTE.ordinal()] = "route";
            if (wfdoc.isBlanketApproveCapable()) {
                flags[buttons.BLANKETAPPROVE.ordinal()] = "blanketApprove";
            }
        }
        if (wfdoc.isApprovalRequested() || wfdoc.isRouteCapable()) {
            flags[buttons.SAVE.ordinal()] = "save";
        }
        if (wfdoc.isCompletionRequested() || wfdoc.isRouteCapable()) {
            flags[buttons.CANCEL.ordinal()] = "cancel";
        }
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] == null) continue;
            list.add(flags[i]);
        }
        return list;
    }

    public static boolean isEditable(EDLContext edlContext, List actions) {
        boolean editable = false;
        editable = WorkflowDocumentState.listContainsItems(actions, UserAction.EDITABLE_ACTIONS);
        Document edlDom = EdlServiceLocator.getEDocLiteService().getDefinitionXml(edlContext.getEdocLiteAssociation());
        XPath xpath = XPathFactory.newInstance().newXPath();
        String xpathExpression = "//config/param[@name='alwaysEditable']";
        try {
            String match = (String)xpath.evaluate(xpathExpression, edlDom, XPathConstants.STRING);
            if (!StringUtils.isBlank((String)match) && match.equals("true")) {
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException("Unable to evaluate xpath expression " + xpathExpression, (Throwable)e);
        }
        return editable;
    }

    public static void addActions(Document dom, Element documentState, List actions) {
        Element actionsPossible = EDLXmlUtils.getOrCreateChildElement(documentState, "actionsPossible", true);
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            String action = it.next().toString();
            Element actionElement = dom.createElement(action);
            if (!Character.isUpperCase(action.charAt(0))) {
                StringBuffer sb = new StringBuffer(action);
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                action = sb.toString();
            }
            actionElement.setAttribute("title", action);
            actionsPossible.appendChild(actionElement);
        }
        Element annotatable = EDLXmlUtils.getOrCreateChildElement(documentState, "annotatable", true);
        annotatable.appendChild(dom.createTextNode(String.valueOf(WorkflowDocumentState.isAnnotatable(actions))));
    }

    public static boolean listContainsItems(List list, Object[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (!list.contains(items[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotatable(List actions) {
        return WorkflowDocumentState.listContainsItems(actions, UserAction.ANNOTATABLE_ACTIONS);
    }

    private static enum buttons {
        ACKNOWLEDGE,
        BLANKETAPPROVE,
        ROUTE,
        SAVE,
        COMPLETE,
        APPROVE,
        DISAPPROVE,
        RETURNTOPREVIOUS,
        FYI,
        CANCEL;

    }
}

