/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.MatchingParam;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Element;

public class UniversityIdWorkflowEDLConfigComponent
extends SimpleWorkflowEDLConfigComponent {
    private boolean required;

    @Override
    public Element getReplacementConfigElement(Element element) {
        Element replacementEl = (Element)element.cloneNode(true);
        Element type = (Element)replacementEl.getElementsByTagName("type").item(0);
        type.setTextContent("text");
        Element validation = (Element)replacementEl.getElementsByTagName("validation").item(0);
        if (validation != null && validation.getAttribute("required").equals("true")) {
            this.required = true;
        }
        return replacementEl;
    }

    @Override
    public String getErrorMessage(Element originalConfigElement, RequestParser requestParser, MatchingParam param) {
        if (param.getParamValue().length() == 0 && this.required) {
            return "University ID is a required field";
        }
        if (param.getParamValue().length() == 0 && !this.required) {
            return null;
        }
        String employeeId = param.getParamValue();
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(employeeId);
        if (principal == null) {
            return "The value " + employeeId + " is an invalid University ID";
        }
        return null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

