/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.edl.impl.EDLController;
import org.kuali.rice.edl.impl.EDLGlobalConfig;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.service.EDocLiteService;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EDLControllerFactory {
    private static final Logger LOG = Logger.getLogger(EDLControllerFactory.class);

    private EDLControllerFactory() {
        throw new UnsupportedOperationException("do not call");
    }

    public static EDLController createEDLController(EDocLiteAssociation edlAssociation, EDLGlobalConfig edlGlobalConfig) {
        EDLController edlController = new EDLController();
        edlController.setEdocLiteAssociation(edlAssociation);
        try {
            edlController.setEdlGlobalConfig(edlGlobalConfig);
            edlController.setDefaultDOM(EDLControllerFactory.getDefaultDOM(edlAssociation));
            EDLControllerFactory.loadConfigProcessors(edlController, edlGlobalConfig);
            EDLControllerFactory.loadPreProcessors(edlController, edlGlobalConfig);
            EDLControllerFactory.loadPostProcessor(edlController, edlGlobalConfig);
            EDLControllerFactory.loadStateComponents(edlController, edlGlobalConfig);
            EDLControllerFactory.loadStyle(edlController);
        }
        catch (Exception e) {
            String edl = null;
            if (edlAssociation != null) {
                edl = edlAssociation.getEdlName();
            }
            String message = "Error creating controller for EDL" + (edl == null ? "" : ": " + edl);
            LOG.error((Object)message, (Throwable)e);
            throw new WorkflowRuntimeException("Problems creating controller for EDL: " + edl, (Throwable)e);
        }
        return edlController;
    }

    public static EDLController createEDLController(EDocLiteAssociation edlAssociation, EDLGlobalConfig edlGlobalConfig, DocumentRouteHeaderValue document) {
        EDLController edlController = EDLControllerFactory.createEDLController(edlAssociation, edlGlobalConfig);
        try {
            Document defaultDom = edlController.getDefaultDOM();
            Document documentDom = XmlHelper.readXml((String)document.getDocContent());
            Element documentData = (Element)documentDom.getElementsByTagName("data").item(0);
            if (documentData != null) {
                Element defaultDomEDL = EDLXmlUtils.getEDLContent(defaultDom, false);
                Element defaultDomData = (Element)defaultDomEDL.getElementsByTagName("data").item(0);
                defaultDomEDL.replaceChild(defaultDom.importNode(documentData, true), defaultDomData);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created default Node from document id " + document.getDocumentId() + " content " + XmlJotter.jotNode((Node)defaultDom)));
            }
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Problems creating controller for EDL " + edlAssociation.getEdlName() + " document " + document.getDocumentId(), (Throwable)e);
        }
        return edlController;
    }

    private static synchronized void loadStyle(EDLController edlController) throws Exception {
        EDocLiteService edlService = EDLControllerFactory.getEDLService();
        Templates styleSheet = edlService.getStyleAsTranslet(edlController.getEdocLiteAssociation().getStyle());
        edlController.setStyle(styleSheet);
    }

    private static synchronized void loadPreProcessors(EDLController edlController, EDLGlobalConfig edlGlobalConfig) {
        edlController.setPreProcessors(EDLControllerFactory.cloneConfigMap(edlGlobalConfig.getPreProcessors(), edlController.getDefaultDOM()));
    }

    private static synchronized void loadPostProcessor(EDLController edlController, EDLGlobalConfig edlGlobalConfig) {
        edlController.setPostProcessors(EDLControllerFactory.cloneConfigMap(edlGlobalConfig.getPostProcessors(), edlController.getDefaultDOM()));
    }

    private static synchronized void loadStateComponents(EDLController edlController, EDLGlobalConfig edlGlobalConfig) {
        edlController.setStateComponents(EDLControllerFactory.cloneConfigMap(edlGlobalConfig.getStateComponents(), edlController.getDefaultDOM()));
    }

    private static synchronized void loadConfigProcessors(EDLController edlController, EDLGlobalConfig edlGlobalConfig) throws Exception {
        EDocLiteAssociation edlAssociation = edlController.getEdocLiteAssociation();
        Document document = EDLControllerFactory.getEDLService().getDefinitionXml(edlAssociation);
        Element definitionElement = (Element)document.getFirstChild();
        LinkedHashMap<Node, Class> configProcessorMappings = new LinkedHashMap<Node, Class>();
        edlController.setEdlGlobalConfig(edlGlobalConfig);
        NodeList edlDefinitionNodes = definitionElement.getChildNodes();
        for (int i = 0; i < edlDefinitionNodes.getLength(); ++i) {
            Node definitionNode = edlDefinitionNodes.item(i);
            Class configProcessorClass = edlGlobalConfig.getConfigProcessor(definitionNode);
            if (configProcessorClass == null) continue;
            configProcessorMappings.put(definitionNode, configProcessorClass);
        }
        edlController.setConfigProcessors(EDLControllerFactory.cloneConfigMap(configProcessorMappings, edlController.getDefaultDOM()));
    }

    private static synchronized Map cloneConfigMap(Map configMap, Document defaultDom) {
        LinkedHashMap tempConfigProcessors = new LinkedHashMap();
        for (Map.Entry configProcessorMapping : configMap.entrySet()) {
            tempConfigProcessors.put(defaultDom.importNode((Node)configProcessorMapping.getKey(), true), configProcessorMapping.getValue());
        }
        return tempConfigProcessors;
    }

    private static EDocLiteService getEDLService() {
        return EdlServiceLocator.getEDocLiteService();
    }

    private static Document getDefaultDOM(EDocLiteAssociation edlAssociation) throws Exception {
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element rootElement = dom.createElement("documentContent");
        dom.appendChild(rootElement);
        Element edlContentElement = EDLXmlUtils.getEDLContent(dom, true);
        EDLXmlUtils.getDataFromEDLDocument(edlContentElement, true);
        Element edlData = EDLXmlUtils.getChildElement(edlContentElement, "data");
        edlData.setAttribute("edlName", edlAssociation.getEdlName());
        return dom;
    }
}

