/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EDLGlobalConfig {
    private Map preProcessors = new HashMap();
    private Map postProcessors = new HashMap();
    private Map stateComponents = new HashMap();
    private Map configProcessors = new LinkedHashMap();

    public void addPreProcessor(String preProcessorName, Element element) {
        try {
            this.preProcessors.put(Class.forName(preProcessorName), element);
        }
        catch (ClassNotFoundException ce) {
            throw new WorkflowRuntimeException("Class " + preProcessorName + " not found.", (Throwable)ce);
        }
    }

    public void addPostProcessor(String postProcessorName, Element configElement) {
        try {
            this.postProcessors.put(Class.forName(postProcessorName), configElement);
        }
        catch (ClassNotFoundException ce) {
            throw new WorkflowRuntimeException("Class " + postProcessorName + " not found.", (Throwable)ce);
        }
    }

    public void addStateComponent(String stateComponentName, Element configElement) {
        try {
            this.stateComponents.put(Class.forName(stateComponentName), configElement);
        }
        catch (ClassNotFoundException ce) {
            throw new WorkflowRuntimeException("Class " + stateComponentName + " not found.", (Throwable)ce);
        }
    }

    public void addConfigProcessor(String xpathExpression, String configProcessorName) {
        Class<?> configProcessor;
        try {
            configProcessor = Class.forName(configProcessorName);
        }
        catch (ClassNotFoundException ce) {
            throw new WorkflowRuntimeException("Class " + configProcessorName + " not found.", (Throwable)ce);
        }
        if (this.configProcessors.containsKey(configProcessor)) {
            throw new WorkflowRuntimeException("Config processor " + configProcessorName + " attempted to register an xpath expression twice.  " + "The expression being used is " + this.configProcessors.get(configProcessor));
        }
        this.configProcessors.put(configProcessor, xpathExpression);
    }

    public Map getPreProcessors() {
        return this.preProcessors;
    }

    public Map getPostProcessors() {
        return this.postProcessors;
    }

    public Map getStateComponents() {
        return this.stateComponents;
    }

    public Class getConfigProcessor(Node configElement) {
        if (configElement instanceof Element) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String xpathExpression = "";
            try {
                for (Map.Entry configProcessor : this.configProcessors.entrySet()) {
                    xpathExpression = (String)configProcessor.getKey();
                    Boolean match = (Boolean)xpath.evaluate(xpathExpression, configElement, XPathConstants.BOOLEAN);
                    if (!match.booleanValue()) continue;
                    return (Class)configProcessor.getValue();
                }
                return null;
            }
            catch (XPathExpressionException e) {
                throw new WorkflowRuntimeException("Unable to evaluate xpath expression " + xpathExpression, (Throwable)e);
            }
            catch (Exception ie) {
                throw new WorkflowRuntimeException((Throwable)ie);
            }
        }
        return null;
    }

    public Map getConfigProcessors() {
        return this.configProcessors;
    }

    public void setConfigProcessors(Map configProcessors) {
        this.configProcessors = configProcessors;
    }

    public void setPostProcessors(Map postProcessors) {
        this.postProcessors = postProcessors;
    }

    public void setPreProcessors(Map preProcessors) {
        this.preProcessors = preProcessors;
    }

    public void setStateComponents(Map stateComponents) {
        this.stateComponents = stateComponents;
    }
}

