/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;

class SessionListenerSupport {
    private Wagon wagon;
    private Set<SessionListener> listeners = new HashSet<SessionListener>();

    public SessionListenerSupport(Wagon wagon) {
        this.wagon = wagon;
    }

    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListener(SessionListener listener) {
        return this.listeners.contains(listener);
    }

    public void fireSessionOpening() {
        SessionEvent event = new SessionEvent(this.wagon, 5);
        for (SessionListener listener : this.listeners) {
            listener.sessionOpening(event);
        }
    }

    public void fireSessionOpened() {
        SessionEvent event = new SessionEvent(this.wagon, 6);
        for (SessionListener listener : this.listeners) {
            listener.sessionOpened(event);
        }
    }

    public void fireSessionDisconnecting() {
        SessionEvent event = new SessionEvent(this.wagon, 2);
        for (SessionListener listener : this.listeners) {
            listener.sessionDisconnecting(event);
        }
    }

    public void fireSessionDisconnected() {
        SessionEvent event = new SessionEvent(this.wagon, 3);
        for (SessionListener listener : this.listeners) {
            listener.sessionDisconnected(event);
        }
    }

    public void fireSessionConnectionRefused() {
        SessionEvent event = new SessionEvent(this.wagon, 4);
        for (SessionListener listener : this.listeners) {
            listener.sessionConnectionRefused(event);
        }
    }

    public void fireSessionLoggedIn() {
        SessionEvent event = new SessionEvent(this.wagon, 7);
        for (SessionListener listener : this.listeners) {
            listener.sessionLoggedIn(event);
        }
    }

    public void fireSessionLoggedOff() {
        SessionEvent event = new SessionEvent(this.wagon, 8);
        for (SessionListener listener : this.listeners) {
            listener.sessionLoggedOff(event);
        }
    }

    public void fireSessionError(Exception e) {
        SessionEvent event = new SessionEvent(this.wagon, e);
        for (SessionListener listener : this.listeners) {
            listener.sessionError(event);
        }
    }
}

