/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.eps;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.output.AbstractCanvasProvider;
import org.krysalis.barcode.tools.UnitConv;

public class EPSCanvasProvider
extends AbstractCanvasProvider {
    private OutputStream out;
    private Writer writer;
    private DecimalFormat df;
    private IOException firstError;
    private double height;

    public EPSCanvasProvider(OutputStream out) throws IOException {
        this.out = out;
        try {
            this.writer = new OutputStreamWriter(out, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Incompatible VM: Need US-ASCII encoding", (Throwable)uee);
        }
    }

    protected DecimalFormat getDecimalFormat() {
        if (this.df == null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df = new DecimalFormat("0.####", dfs);
        }
        return this.df;
    }

    private String format(double coord) {
        return this.getDecimalFormat().format(coord);
    }

    private String formatmm(double coord) {
        return this.getDecimalFormat().format(UnitConv.mm2pt(coord));
    }

    private String formatmm(double x, double y) {
        return this.formatmm(x) + " " + this.formatmm(this.height - y);
    }

    private void writeHeader(double width, double height) throws IOException {
        this.writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        double widthpt = UnitConv.mm2pt(width);
        double heightpt = UnitConv.mm2pt(height);
        this.writer.write("%%BoundingBox: 0 0 " + Math.round(Math.ceil(widthpt)) + " " + Math.round(Math.ceil(heightpt)) + "\n");
        this.writer.write("%%HiResBoundingBox: 0 0 " + this.format(widthpt) + " " + this.format(heightpt) + "\n");
        this.writer.write("%%Creator: Krysalis Barcode (http://www.krysalis.org/barcode)\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.writer.write("%%CreationDate: " + sdf.format(new Date()) + "\n");
        this.writer.write("%%LanguageLevel: 1\n");
        this.writer.write("%%EndComments\n");
        this.writer.write("%%BeginProlog\n");
        this.writer.write("%%BeginProcSet: krysalis-barcode-procset 1.0\n");
        this.writer.write("/rf {\n");
        this.writer.write("newpath\n");
        this.writer.write("4 -2 roll moveto\n");
        this.writer.write("dup neg 0 exch rlineto\n");
        this.writer.write("exch 0 rlineto\n");
        this.writer.write("0 neg exch rlineto\n");
        this.writer.write("closepath fill\n");
        this.writer.write("} def\n");
        this.writer.write("/ct {\n");
        this.writer.write("moveto dup stringwidth\n");
        this.writer.write("2 div neg exch 2 div neg exch\n");
        this.writer.write("rmoveto show\n");
        this.writer.write("} def\n");
        this.writer.write("/jt {\n");
        this.writer.write("4 -1 roll dup stringwidth pop\n");
        this.writer.write("5 -2 roll 1 index sub\n");
        this.writer.write("3 -1 roll sub\n");
        this.writer.write("2 index length\n");
        this.writer.write("1 sub div\n");
        this.writer.write("0 4 -1 roll 4 -1 roll 5 -1 roll\n");
        this.writer.write("moveto ashow\n");
        this.writer.write("} def\n");
        this.writer.write("%%EndProcSet: krysalis-barcode-procset 1.0\n");
        this.writer.write("%%EndProlog\n");
    }

    public void finish() throws IOException {
        if (this.firstError != null) {
            throw this.firstError;
        }
        this.writer.write("%%EOF\n");
        this.writer.flush();
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        if (this.firstError != null) {
            return;
        }
        this.height = dim.getHeightPlusQuiet();
        try {
            this.writeHeader(dim.getWidthPlusQuiet(), dim.getHeightPlusQuiet());
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        if (this.firstError != null) {
            return;
        }
        try {
            this.writer.write(this.formatmm(x, y) + " " + this.formatmm(w) + " " + this.formatmm(h) + " rf\n");
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    public void deviceJustifiedText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        if (this.firstError != null) {
            return;
        }
        try {
            this.writer.write("/" + fontName + " findfont " + fontSize + " scalefont setfont\n");
            this.writer.write("(" + text + ") " + this.formatmm(x1) + " " + this.formatmm(x2) + " " + this.formatmm(this.height - y1) + " jt\n");
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    public void deviceCenteredText(String text, double x1, double x2, double y1, String fontName, double fontSize) {
        if (this.firstError != null) {
            return;
        }
        try {
            this.writer.write("/" + fontName + " findfont " + fontSize + " scalefont setfont\n");
            this.writer.write("(" + text + ") " + this.formatmm((x1 + x2) / 2.0, y1) + " ct\n");
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }
}

