/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.bitmap;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.krysalis.barcode.output.bitmap.BitmapEncoder;

public class SunJPEGBitmapEncoder
implements BitmapEncoder {
    private static final String MIME_JPEG = "image/jpeg";

    public SunJPEGBitmapEncoder() throws ClassNotFoundException {
        Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
    }

    public String[] getSupportedMIMETypes() {
        return new String[]{MIME_JPEG};
    }

    public void encode(BufferedImage image, OutputStream out, String mime, int resolution) throws IOException {
        if (!MIME_JPEG.equals(mime)) {
            throw new IllegalArgumentException("Unsupported MIME type: " + mime);
        }
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setXDensity(resolution);
        param.setYDensity(resolution);
        param.setDensityUnit(1);
        encoder.encode(image, param);
    }
}

