/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.output.bitmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.output.bitmap.BitmapEncoder;
import org.krysalis.barcode.output.bitmap.BitmapEncoderRegistry;
import org.krysalis.barcode.output.java2d.Java2DCanvasProvider;
import org.krysalis.barcode.tools.UnitConv;

public class BitmapBuilder {
    protected BitmapBuilder() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage prepareImage(BarcodeDimension dim, int resolution, int imageType) {
        int bmw = UnitConv.mm2px(dim.getWidthPlusQuiet(), resolution);
        int bmh = UnitConv.mm2px(dim.getHeightPlusQuiet(), resolution);
        BufferedImage bi = new BufferedImage(bmw, bmh, imageType);
        return bi;
    }

    public static Graphics2D prepareGraphics2D(BufferedImage image, BarcodeDimension dim, boolean antiAlias) {
        Graphics2D g2d = image.createGraphics();
        if (antiAlias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setBackground(Color.white);
        g2d.setColor(Color.black);
        g2d.clearRect(0, 0, image.getWidth(), image.getHeight());
        g2d.scale((double)image.getWidth() / dim.getWidthPlusQuiet(), (double)image.getHeight() / dim.getHeightPlusQuiet());
        return g2d;
    }

    public static BufferedImage getImage(BarcodeGenerator bargen, String msg, int resolution) {
        BarcodeDimension dim = bargen.calcDimensions(msg);
        BufferedImage bi = BitmapBuilder.prepareImage(dim, resolution, 10);
        Graphics2D g2d = BitmapBuilder.prepareGraphics2D(bi, dim, true);
        Java2DCanvasProvider provider = new Java2DCanvasProvider(g2d);
        bargen.generateBarcode(provider, msg);
        bi.flush();
        return bi;
    }

    public static void saveImage(BufferedImage image, OutputStream out, String mime, int resolution) throws IOException {
        BitmapEncoder encoder = BitmapEncoderRegistry.getInstance(mime);
        encoder.encode(image, out, mime, resolution);
    }

    public static void outputBarcodeImage(BarcodeGenerator bargen, String msg, OutputStream out, String mime, int resolution) throws IOException {
        BufferedImage image = BitmapBuilder.getImage(bargen, msg, resolution);
        BitmapBuilder.saveImage(image, out, mime, resolution);
    }
}

