/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import java.util.Stack;
import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.HumanReadablePlacement;
import org.krysalis.barcode.impl.EAN13;
import org.krysalis.barcode.impl.EAN8;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.impl.UPCEAN;
import org.krysalis.barcode.impl.UPCEANLogicImpl;
import org.krysalis.barcode.output.Canvas;

public class UPCEANCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private UPCEAN bcImpl;
    private Canvas canvas;
    private double x = 0.0;
    private BarcodeDimension dim;
    private String msg;
    private String lastgroup;
    private double groupx;
    private boolean inMsgGroup;
    private boolean inSupplemental;
    private Stack groupStack = new Stack();

    public UPCEANCanvasLogicHandler(GenericBarcodeImpl bcImpl, Canvas canvas) {
        if (!(bcImpl instanceof UPCEAN)) {
            throw new IllegalArgumentException("This LogicHandler can only be used with UPC and EAN barcode implementations");
        }
        this.bcImpl = (UPCEAN)bcImpl;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcImpl.hasQuietZone()) {
            return this.bcImpl.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg) {
        this.msg = msg;
        this.dim = this.bcImpl.calcDimensions(msg);
        this.canvas.establishDimensions(this.dim);
        this.x = this.getStartX();
        this.inMsgGroup = false;
        this.inSupplemental = false;
    }

    public void startBarGroup(BarGroup type, String submsg) {
        if (type != BarGroup.UPC_EAN_GUARD) {
            if (type == BarGroup.UPC_EAN_GROUP) {
                this.inMsgGroup = true;
                this.groupx = this.x;
                this.lastgroup = submsg;
            } else if (type == BarGroup.UPC_EAN_LEAD) {
                this.lastgroup = submsg;
            } else if (type == BarGroup.UPC_EAN_CHECK) {
                if (!this.inMsgGroup) {
                    this.lastgroup = submsg;
                }
            } else if (type == BarGroup.UPC_EAN_SUPP) {
                this.inSupplemental = true;
                this.x += this.bcImpl.getQuietZone();
                this.groupx = this.x;
            }
        }
        this.groupStack.push(type);
    }

    public void addBar(boolean black, int width) {
        double w = this.bcImpl.getBarWidth(width);
        if (black) {
            if (!this.inSupplemental) {
                if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                    this.canvas.drawRectWH(this.x, 0.0, w, this.bcImpl.getHeight());
                } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                    double y;
                    double h;
                    if (this.inMsgGroup) {
                        h = this.bcImpl.getBarHeight();
                        y = this.bcImpl.getHumanReadableHeight();
                    } else {
                        h = this.bcImpl.getBarHeight() + this.bcImpl.getHumanReadableHeight() / 2.0;
                        y = this.bcImpl.getHumanReadableHeight() / 2.0;
                    }
                    this.canvas.drawRectWH(this.x, y, w, h);
                } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                    double h = this.inMsgGroup ? this.bcImpl.getBarHeight() : this.bcImpl.getBarHeight() + this.bcImpl.getHumanReadableHeight() / 2.0;
                    this.canvas.drawRectWH(this.x, 0.0, w, h);
                }
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                double h = this.bcImpl.getBarHeight();
                double y = this.bcImpl.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, y, w, h);
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                double h = this.bcImpl.getBarHeight() + this.bcImpl.getHumanReadableHeight() / 2.0 - this.bcImpl.getHumanReadableHeight();
                double y = this.bcImpl.getHumanReadableHeight() / 2.0;
                this.canvas.drawRectWH(this.x, y, w, h);
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                double h = this.bcImpl.getBarHeight() + this.bcImpl.getHumanReadableHeight() / 2.0 - this.bcImpl.getHumanReadableHeight();
                double y = this.bcImpl.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, y, w, h);
            }
        }
        this.x += w;
    }

    private boolean isEAN() {
        return this.bcImpl instanceof EAN13 || this.bcImpl instanceof EAN8;
    }

    public void endBarGroup() {
        BarGroup group = (BarGroup)((Object)this.groupStack.pop());
        if (group == BarGroup.UPC_EAN_GROUP) {
            this.inMsgGroup = false;
            if (this.lastgroup == null) {
                return;
            }
            int colonPos = this.lastgroup.indexOf(":");
            String grouptext = this.lastgroup;
            if (colonPos >= 0) {
                String lead = new Character(grouptext.charAt(0)).toString();
                this.drawLeadChar(lead);
                grouptext = grouptext.substring(colonPos + 1);
            }
            this.drawGroupText(grouptext);
        } else if (group == BarGroup.UPC_EAN_LEAD) {
            if (!this.isEAN()) {
                this.drawLeadChar(this.lastgroup);
            }
        } else if (group == BarGroup.UPC_EAN_CHECK) {
            if (!this.isEAN()) {
                this.drawTrailingChar(this.lastgroup);
            }
        } else if (group == BarGroup.UPC_EAN_SUPP) {
            this.drawSupplementalText(UPCEANLogicImpl.retrieveSupplemental(this.msg));
            this.inSupplemental = false;
        }
    }

    private void drawLeadChar(String lead) {
        double leadw = 7.0 * this.bcImpl.getBarWidth(1);
        double leadx = this.getStartX() - 3.0 * this.bcImpl.getBarWidth(1) - leadw;
        if (this.bcImpl.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.bcImpl.drawCenteredText(this.canvas, lead, leadx, leadx + leadw, this.bcImpl.getHumanReadableHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.bcImpl.drawCenteredText(this.canvas, lead, leadx, leadx + leadw, this.bcImpl.getHeight());
            }
        }
    }

    private void drawTrailingChar(String trailer) {
        double trailerw = 7.0 * this.bcImpl.getBarWidth(1);
        double trailerx = this.getStartX() + this.dim.getWidth() - this.bcImpl.supplementalWidth(this.msg) + 3.0 * this.bcImpl.getBarWidth(1);
        if (this.bcImpl.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.bcImpl.drawCenteredText(this.canvas, trailer, trailerx, trailerx + trailerw, this.bcImpl.getHumanReadableHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.bcImpl.drawCenteredText(this.canvas, trailer, trailerx, trailerx + trailerw, this.bcImpl.getHeight());
            }
        }
    }

    private void drawGroupText(String text) {
        if (this.bcImpl.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.bcImpl.drawJustifiedText(this.canvas, text, this.groupx + this.bcImpl.getBarWidth(1), this.x - this.bcImpl.getBarWidth(1), this.bcImpl.getHumanReadableHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.bcImpl.drawJustifiedText(this.canvas, text, this.groupx + this.bcImpl.getBarWidth(1), this.x - this.bcImpl.getBarWidth(1), this.bcImpl.getHeight());
            }
        }
    }

    private void drawSupplementalText(String supp) {
        if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            this.bcImpl.drawCenteredText(this.canvas, supp, this.groupx, this.x, this.bcImpl.getHeight());
        } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            this.bcImpl.drawCenteredText(this.canvas, supp, this.groupx, this.x, this.bcImpl.getHumanReadableHeight());
        }
    }

    public void endBarcode() {
    }
}

