/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;

public class POSTNETLogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{2, 2, 1, 1, 1}, {1, 1, 1, 2, 2}, {1, 1, 2, 1, 2}, {1, 1, 2, 2, 1}, {1, 2, 1, 1, 2}, {1, 2, 1, 2, 1}, {1, 2, 2, 1, 1}, {2, 1, 1, 1, 2}, {2, 1, 1, 2, 1}, {2, 1, 2, 1, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private static final char DASH = '-';

    public POSTNETLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String msg) {
        int tmp = 0;
        int i = 0;
        while (i < msg.length()) {
            if (!POSTNETLogicImpl.isIgnoredChar(msg.charAt(i)) && (tmp += Character.digit(msg.charAt(i), 10)) > 9) {
                tmp -= 10;
            }
            ++i;
        }
        return Character.forDigit((10 - tmp) % 10, 10);
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = POSTNETLogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private static boolean isValidChar(char ch) {
        return Character.isDigit(ch) || POSTNETLogicImpl.isIgnoredChar(ch);
    }

    public static boolean isIgnoredChar(char c) {
        return c == '-';
    }

    public static String removeIgnoredCharacters(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        int i = 0;
        while (i < msg.length()) {
            char ch = msg.charAt(i);
            if (!POSTNETLogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            if (!POSTNETLogicImpl.isIgnoredChar(ch)) {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    private int heightAt(char ch, int index) {
        int chidx = Character.digit(ch, 10);
        if (chidx >= 0) {
            byte height = CHARSET[chidx][index];
            return height;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c) {
        if (POSTNETLogicImpl.isIgnoredChar(c)) {
            return;
        }
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        int i = 0;
        while (i < 5) {
            int height = this.heightAt(c, i);
            logic.addBar(true, height);
            this.addIntercharacterGap(logic);
            i = (byte)(i + 1);
        }
        logic.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler logic) {
        logic.addBar(false, -1);
    }

    private void handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            sb.append(POSTNETLogicImpl.calcChecksum(sb.toString()));
        } else if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!POSTNETLogicImpl.validateChecksum(sb.toString())) {
                throw new IllegalArgumentException("Message '" + sb.toString() + "' has a bad checksum. Expected: " + POSTNETLogicImpl.calcChecksum(sb.toString()));
            }
        } else {
            if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
                return;
            }
            if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
                return;
            }
        }
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        logic.startBarcode(msg);
        StringBuffer sb = new StringBuffer(msg);
        this.handleChecksum(sb);
        logic.addBar(true, 2);
        this.addIntercharacterGap(logic);
        int i = 0;
        while (i < sb.length()) {
            char ch = sb.charAt(i);
            if (!POSTNETLogicImpl.isValidChar(ch)) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
            ++i;
        }
        logic.addBar(true, 2);
        logic.endBarcode();
    }
}

