/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;

public class Interleaved2Of5LogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{1, 1, 2, 2, 1}, {2, 1, 1, 1, 2}, {1, 2, 1, 1, 2}, {2, 2, 1, 1, 1}, {1, 1, 2, 1, 2}, {2, 1, 2, 1, 1}, {1, 2, 2, 1, 1}, {1, 1, 1, 2, 2}, {2, 1, 1, 2, 1}, {1, 2, 1, 2, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public Interleaved2Of5LogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String msg, int oddMultiplier, int evenMultiplier) {
        int oddsum = 0;
        int evensum = 0;
        int i = 0;
        while (i < msg.length()) {
            if (i % 2 == 0) {
                evensum += Character.digit(msg.charAt(i), 10);
            } else {
                oddsum += Character.digit(msg.charAt(i), 10);
            }
            ++i;
        }
        int check = 10 - (evensum * oddMultiplier + oddsum * evenMultiplier) % 10;
        if (check >= 10) {
            check = 0;
        }
        return Character.forDigit(check, 10);
    }

    public static char calcChecksum(String msg) {
        return Interleaved2Of5LogicImpl.calcChecksum(msg, 3, 1);
    }

    public static boolean validateChecksum(String msg) {
        char expected;
        char actual = msg.charAt(msg.length() - 1);
        return actual == (expected = Interleaved2Of5LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
    }

    private int widthAt(char ch, int index) {
        if (Character.isDigit(ch)) {
            int digit = Character.digit(ch, 10);
            byte width = CHARSET[digit][index];
            return width;
        }
        throw new IllegalArgumentException("Invalid character '" + ch + " (" + Character.getNumericValue(ch) + ")'. Expected a digit.");
    }

    private void encodeGroup(ClassicBarcodeLogicHandler logic, String group) {
        if (group.length() != 2) {
            throw new IllegalArgumentException("Parameter group must have two characters");
        }
        logic.startBarGroup(BarGroup.MSG_CHARACTER, group);
        int index = 0;
        while (index < 5) {
            logic.addBar(true, this.widthAt(group.charAt(0), index));
            logic.addBar(false, this.widthAt(group.charAt(1), index));
            ++index;
        }
        logic.endBarGroup();
    }

    private String handleChecksum(String msg) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            return msg + Interleaved2Of5LogicImpl.calcChecksum(msg);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!Interleaved2Of5LogicImpl.validateChecksum(msg)) {
                throw new IllegalArgumentException("Message '" + msg + "' has a bad checksum. Expected: " + Interleaved2Of5LogicImpl.calcChecksum(msg.substring(0, msg.length() - 1)));
            }
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + (Object)((Object)this.getChecksumMode()));
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String s = this.handleChecksum(msg);
        if (s.length() % 2 != 0) {
            s = "0" + s;
        }
        logic.startBarcode(msg);
        logic.startBarGroup(BarGroup.START_CHARACTER, null);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.endBarGroup();
        int i = 0;
        do {
            this.encodeGroup(logic, s.substring(i, i + 2));
        } while ((i += 2) < s.length());
        logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
        logic.addBar(true, 2);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.endBarGroup();
        logic.endBarcode();
    }
}

