/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.impl.Interleaved2Of5LogicImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public class Interleaved2Of5
extends GenericBarcodeImpl
implements Configurable {
    private static final double DEFAULT_WIDE_FACTOR = 3.0;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double wideFactor = 3.0;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.21mm"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
        this.checksumMode = ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName()));
        this.wideFactor = cfg.getChild("wide-factor").getValueAsFloat(3.0f);
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Interleaved2Of5LogicImpl impl = new Interleaved2Of5LogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        int msgLen = msg.length();
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            ++msgLen;
        }
        if (msgLen % 2 != 0) {
            ++msgLen;
        }
        double charwidth = 2.0 * this.wideFactor + 3.0;
        double width = ((double)msgLen * charwidth + 6.0 + this.wideFactor) * this.moduleWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }
}

