/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.impl.UPCEANLogicImpl;

public class EAN8LogicImpl
extends UPCEANLogicImpl {
    public EAN8LogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 7 || msg.length() > 8) {
            throw new IllegalArgumentException("Message must be 7 or 8 characters long. Message: " + msg);
        }
    }

    private String handleChecksum(String msg) {
        ChecksumMode mode = this.getChecksumMode();
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 7) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 8) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() > 7) {
                throw new IllegalArgumentException("Message is too long (max. 7 characters)");
            }
            if (msg.length() < 7) {
                throw new IllegalArgumentException("Message must be 7 characters long");
            }
            return msg + UPCEANLogicImpl.calcChecksum(msg);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() > 8) {
                throw new IllegalArgumentException("Message is too long (max. 8 characters)");
            }
            if (msg.length() < 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            char check = msg.charAt(7);
            if (check != (expected = UPCEANLogicImpl.calcChecksum(msg.substring(0, 7)))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + (Object)((Object)mode));
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String supp = UPCEANLogicImpl.retrieveSupplemental(msg);
        String s = UPCEANLogicImpl.removeSupplemental(msg);
        EAN8LogicImpl.validateMessage(s);
        String canonicalMessage = s = this.handleChecksum(s);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage);
        this.drawSideGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(0, 4));
        int i = 0;
        while (i < 4) {
            this.encodeChar(logic, s.charAt(i), 0);
            ++i;
        }
        logic.endBarGroup();
        this.drawCenterGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(4, 8));
        int i2 = 4;
        while (i2 < 7) {
            this.encodeChar(logic, s.charAt(i2), 2);
            ++i2;
        }
        char check = s.charAt(7);
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(check).toString());
        this.encodeChar(logic, check, 2);
        logic.endBarGroup();
        logic.endBarGroup();
        this.drawSideGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

