/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.impl.UPCEANLogicImpl;

public class EAN13LogicImpl
extends UPCEANLogicImpl {
    private static final byte A = 0;
    private static final byte B = 1;
    private static final byte[][] FIRSTFLAG = new byte[][]{{0, 0, 0, 0, 0}, {0, 1, 0, 1, 1}, {0, 1, 1, 0, 1}, {0, 1, 1, 1, 0}, {1, 0, 0, 1, 1}, {1, 1, 0, 0, 1}, {1, 1, 1, 0, 0}, {1, 0, 1, 0, 1}, {1, 0, 1, 1, 0}, {1, 1, 0, 1, 0}};

    public EAN13LogicImpl(ChecksumMode mode) {
        super(mode);
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 12 || msg.length() > 13) {
            throw new IllegalArgumentException("Message must be 11 or 12 characters long. Message: " + msg);
        }
    }

    private String handleChecksum(String msg) {
        ChecksumMode mode = this.getChecksumMode();
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 12) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 13) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() > 12) {
                throw new IllegalArgumentException("Message is too long (max. 12 characters)");
            }
            if (msg.length() < 12) {
                throw new IllegalArgumentException("Message must be 12 characters long");
            }
            return msg + UPCEANLogicImpl.calcChecksum(msg);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() > 13) {
                throw new IllegalArgumentException("Message is too long (max. 13 characters)");
            }
            if (msg.length() < 13) {
                throw new IllegalArgumentException("Message must be 13 characters long");
            }
            char check = msg.charAt(12);
            if (check != (expected = UPCEANLogicImpl.calcChecksum(msg.substring(0, 12)))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + (Object)((Object)mode));
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String supp = UPCEANLogicImpl.retrieveSupplemental(msg);
        String s = UPCEANLogicImpl.removeSupplemental(msg);
        EAN13LogicImpl.validateMessage(s);
        String canonicalMessage = s = this.handleChecksum(s);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage);
        this.drawSideGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.charAt(0) + ":" + s.substring(1, 7));
        this.encodeChar(logic, s.charAt(1), 0);
        byte flag = (byte)Character.digit(s.charAt(0), 10);
        int i = 2;
        while (i < 7) {
            this.encodeChar(logic, s.charAt(i), FIRSTFLAG[flag][i - 2]);
            ++i;
        }
        logic.endBarGroup();
        this.drawCenterGuard(logic);
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(7, 13));
        int i2 = 7;
        while (i2 < 12) {
            this.encodeChar(logic, s.charAt(i2), 2);
            ++i2;
        }
        char check = s.charAt(12);
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, new Character(check).toString());
        this.encodeChar(logic, check, 2);
        logic.endBarGroup();
        logic.endBarGroup();
        this.drawSideGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

