/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.BaselineAlignment;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.HumanReadablePlacement;
import org.krysalis.barcode.impl.HeightVariableBarcodeImpl;
import org.krysalis.barcode.output.Canvas;

public class DefaultHeightVariableLogicHandler
implements ClassicBarcodeLogicHandler {
    private HeightVariableBarcodeImpl bcImpl;
    private Canvas canvas;
    private double x = 0.0;
    private String msg;

    public DefaultHeightVariableLogicHandler(HeightVariableBarcodeImpl bcImpl, Canvas canvas) {
        this.bcImpl = bcImpl;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcImpl.hasQuietZone()) {
            return this.bcImpl.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg) {
        this.msg = msg;
        BarcodeDimension dim = this.bcImpl.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void addBar(boolean black, int height) {
        double w = black ? this.bcImpl.getBarWidth(1) : this.bcImpl.getBarWidth(-1);
        double h = this.bcImpl.getBarHeight(height);
        BaselineAlignment baselinePosition = this.bcImpl.getBaselinePosition();
        if (black) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                    this.canvas.drawRectWH(this.x, this.bcImpl.getHumanReadableHeight(), w, h);
                } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                    this.canvas.drawRectWH(this.x, this.bcImpl.getHeight() - h, w, h);
                }
            } else if (baselinePosition == BaselineAlignment.ALIGN_TOP) {
                this.canvas.drawRectWH(this.x, 0.0, w, h);
            } else if (baselinePosition == BaselineAlignment.ALIGN_BOTTOM) {
                this.canvas.drawRectWH(this.x, this.bcImpl.getBarHeight() - h, w, h);
            }
        }
        this.x += w;
    }

    public void endBarcode() {
        if (this.bcImpl.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.bcImpl.drawCenteredText(this.canvas, this.msg, this.getStartX(), this.x, this.bcImpl.getHumanReadableHeight());
            } else if (this.bcImpl.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.bcImpl.drawCenteredText(this.canvas, this.msg, this.getStartX(), this.x, this.bcImpl.getHeight());
            }
        }
    }

    public void startBarGroup(BarGroup barGroup, String string) {
    }

    public void endBarGroup() {
    }
}

