/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;
import org.krysalis.barcode.impl.Code128Encoder;
import org.krysalis.barcode.impl.DefaultCode128Encoder;

public class Code128LogicImpl {
    public static final char FNC_1 = '\u00f1';
    public static final char FNC_2 = '\u00f2';
    public static final char FNC_3 = '\u00f3';
    public static final char FNC_4 = '\u00f4';
    private static final byte[][] CHARSET = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    private static final byte[] STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};

    public static boolean isValidChar(char ch) {
        return ch >= '\u0000' && ch <= '\u007f' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean isInCodeSetA(char ch) {
        return ch >= '\u0000' && ch <= '_' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean isInCodeSetB(char ch) {
        return ch >= ' ' && ch <= '\u007f' || ch >= '\u00f1' && ch <= '\u00f4';
    }

    public static boolean canBeInCodeSetC(char ch) {
        return ch >= '0' && ch <= '9' || ch == '\u00f1';
    }

    public static String symbolCharToString(int index) {
        switch (index) {
            case 96: {
                return "FNC3/96";
            }
            case 97: {
                return "FNC2/97";
            }
            case 98: {
                return "Shift/98";
            }
            case 99: {
                return "CodeC/99";
            }
            case 100: {
                return "CodeB/FNC4";
            }
            case 101: {
                return "CodeA/FNC4";
            }
            case 102: {
                return "FNC1";
            }
            case 103: {
                return "StartA";
            }
            case 104: {
                return "StartB";
            }
            case 105: {
                return "StartC";
            }
        }
        return "idx" + Integer.toString(index);
    }

    public static String toString(int[] encodedMsg) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < encodedMsg.length) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(Code128LogicImpl.symbolCharToString(encodedMsg[i]));
            ++i;
        }
        return sb.toString();
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, int index) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, Code128LogicImpl.symbolCharToString(index));
        int i = 0;
        while (i < 6) {
            byte width = CHARSET[index][i];
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
            i = (byte)(i + 1);
        }
        logic.endBarGroup();
    }

    protected void encodeStop(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
        int i = 0;
        while (i < 7) {
            byte width = STOP[i];
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
            i = (byte)(i + 1);
        }
        logic.endBarGroup();
    }

    protected Code128Encoder getEncoder() {
        return new DefaultCode128Encoder();
    }

    public int[] createEncodedMessage(String msg) {
        return this.getEncoder().encode(msg);
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        logic.startBarcode(msg);
        int[] encodedMsg = this.createEncodedMessage(msg);
        int i = 0;
        while (i < encodedMsg.length) {
            this.encodeChar(logic, encodedMsg[i]);
            ++i;
        }
        int checksum = encodedMsg[0];
        int i2 = 1;
        while (i2 < encodedMsg.length) {
            checksum += i2 * encodedMsg[i2];
            ++i2;
        }
        this.encodeChar(logic, checksum %= 103);
        this.encodeStop(logic);
        logic.endBarcode();
    }
}

