/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.krysalis.barcode.BarGroup;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.ClassicBarcodeLogicHandler;

public class CodabarLogicImpl {
    private static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'n', 't', '-', '$', ':', '/', '.', '+', '*'};
    protected static final byte[][] CHARSET = new byte[][]{{0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 0, 0, 1}, {1, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 0, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0}, {0, 1, 0, 1, 0, 0, 1}, {0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1}, {1, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 1, 1}};
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public CodabarLogicImpl(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    protected static int getCharIndex(char ch) {
        int i = 0;
        while (i < CHARACTERS.length) {
            if (ch == CHARACTERS[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static boolean isValidChar(char ch) {
        return CodabarLogicImpl.getCharIndex(ch) >= 0;
    }

    protected static boolean isStartStopChar(char ch) {
        return ch == 'a' || ch == 'b' || ch == 'c' || ch == 'd' || ch == 'e' || ch == '*' || ch == 'n' || ch == 't';
    }

    private int widthAt(char ch, int index) throws IllegalArgumentException {
        int chidx = CodabarLogicImpl.getCharIndex(ch);
        if (chidx >= 0) {
            byte binary = CHARSET[chidx][index];
            return binary + 1;
        }
        throw new IllegalArgumentException("Invalid character: " + ch);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler logic, char c) {
        logic.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        int i = 0;
        while (i < 7) {
            int width = this.widthAt(c, i);
            boolean black = i % 2 == 0;
            logic.addBar(black, width);
            i = (byte)(i + 1);
        }
        logic.endBarGroup();
    }

    private void handleChecksum(StringBuffer sb) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            throw new UnsupportedOperationException("No checksums are currently supported for Codabar symbols");
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return;
        }
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        StringBuffer sb = new StringBuffer(msg);
        this.handleChecksum(sb);
        logic.startBarcode(sb.toString());
        int i = 0;
        while (i < sb.length()) {
            char ch;
            if (i > 0) {
                logic.addBar(false, 1);
            }
            if (!CodabarLogicImpl.isValidChar(ch = sb.charAt(i))) {
                throw new IllegalArgumentException("Invalid character: " + ch);
            }
            this.encodeChar(logic, ch);
            ++i;
        }
        logic.endBarcode();
    }
}

