/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.impl;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.ChecksumMode;
import org.krysalis.barcode.impl.CodabarLogicImpl;
import org.krysalis.barcode.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode.impl.GenericBarcodeImpl;
import org.krysalis.barcode.output.Canvas;
import org.krysalis.barcode.output.CanvasProvider;
import org.krysalis.barcode.tools.Length;

public class Codabar
extends GenericBarcodeImpl
implements Configurable {
    protected static final double DEFAULT_WIDE_FACTOR = 3.0;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double wideFactor = 3.0;

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.21mm"), "mm");
        this.moduleWidth = mw.getValueAsMillimeter();
        super.configure(cfg);
        this.checksumMode = ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName()));
        this.wideFactor = cfg.getChild("wide-factor").getValueAsFloat(3.0f);
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        CodabarLogicImpl impl = new CodabarLogicImpl(this.getChecksumMode());
        impl.generateBarcodeLogic(handler, msg);
    }

    private double calcCharWidth(char c) {
        int idx = CodabarLogicImpl.getCharIndex(c);
        if (idx >= 0) {
            int narrow = 0;
            int wide = 0;
            int i = 0;
            while (i < 7) {
                byte width = CodabarLogicImpl.CHARSET[idx][i];
                if (width == 0) {
                    ++narrow;
                } else {
                    ++wide;
                }
                ++i;
            }
            return (double)narrow * this.moduleWidth + (double)wide * this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Invalid character: " + c);
    }

    public BarcodeDimension calcDimensions(String msg) {
        double width = 0.0;
        int i = 0;
        while (i < msg.length()) {
            if (i > 0) {
                width += this.moduleWidth;
            }
            width += this.calcCharWidth(msg.charAt(i));
            ++i;
        }
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

