/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode;

import java.util.HashMap;
import java.util.Map;
import org.krysalis.barcode.BarcodeClassResolver;

public class DefaultBarcodeClassResolver
implements BarcodeClassResolver {
    private Map classes;

    public DefaultBarcodeClassResolver() {
        this.registerBarcodeClass("codabar", "org.krysalis.barcode.impl.Codabar");
        this.registerBarcodeClass("code39", "org.krysalis.barcode.impl.Code39");
        this.registerBarcodeClass("code128", "org.krysalis.barcode.impl.Code128");
        this.registerBarcodeClass("2of5", "org.krysalis.barcode.impl.Interleaved2Of5");
        this.registerBarcodeClass("intl2of5", "org.krysalis.barcode.impl.Interleaved2Of5");
        this.registerBarcodeClass("interleaved2of5", "org.krysalis.barcode.impl.Interleaved2Of5");
        this.registerBarcodeClass("ean-13", "org.krysalis.barcode.impl.EAN13");
        this.registerBarcodeClass("ean13", "org.krysalis.barcode.impl.EAN13");
        this.registerBarcodeClass("ean-8", "org.krysalis.barcode.impl.EAN8");
        this.registerBarcodeClass("ean8", "org.krysalis.barcode.impl.EAN8");
        this.registerBarcodeClass("upc-a", "org.krysalis.barcode.impl.UPCA");
        this.registerBarcodeClass("upca", "org.krysalis.barcode.impl.UPCA");
        this.registerBarcodeClass("upc-e", "org.krysalis.barcode.impl.UPCE");
        this.registerBarcodeClass("upce", "org.krysalis.barcode.impl.UPCE");
        this.registerBarcodeClass("postnet", "org.krysalis.barcode.impl.POSTNET");
    }

    public void registerBarcodeClass(String name, String classname) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        this.classes.put(name.toLowerCase(), classname);
    }

    public Class resolve(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = (String)this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        Class<?> cl = Class.forName(clazz);
        return cl;
    }
}

