/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.gradle.plugin.enforcer.api;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.kordamp.gradle.plugin.enforcer.api.EnforcerContext;
import org.kordamp.gradle.plugin.enforcer.api.EnforcerLevel;
import org.kordamp.gradle.plugin.enforcer.api.EnforcerRule;
import org.kordamp.gradle.plugin.enforcer.api.EnforcerRuleException;

public abstract class AbstractEnforcerRule
implements EnforcerRule,
GroovyObject {
    private final Property<Boolean> enabled;
    private final Property<EnforcerLevel> enforcerLevel;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AbstractEnforcerRule(ObjectFactory objects) {
        Property property;
        Property property2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.enabled = property2 = objects.property(Boolean.class).convention((Object)true);
        this.enforcerLevel = property = objects.property(EnforcerLevel.class).convention((Provider)Providers.notDefined());
    }

    @Override
    public void setEnforcerLevel(String enforcerLevel) {
        if (StringUtils.isNotBlank((CharSequence)enforcerLevel)) {
            this.enforcerLevel.set((Object)EnforcerLevel.valueOf(enforcerLevel.trim().toUpperCase()));
        }
    }

    @Override
    public void validate(EnforcerContext context) throws EnforcerRuleException {
        context.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.resolveClassName(), context}, new String[]{"Validating rule ", " on ", ""})));
        this.doValidate(context);
    }

    @Override
    public void execute(EnforcerContext context) throws EnforcerRuleException {
        context.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.resolveClassName(), context}, new String[]{"Enforcing rule ", " on ", ""})));
        this.doExecute(context);
    }

    protected abstract void doValidate(EnforcerContext var1) throws EnforcerRuleException;

    protected abstract void doExecute(EnforcerContext var1) throws EnforcerRuleException;

    protected String resolveClassName() {
        String ruleClassName = this.getClass().getName();
        if (ruleClassName.endsWith("_Decorated")) {
            ruleClassName = StringGroovyMethods.minus((CharSequence)ruleClassName, (Object)"_Decorated");
        }
        return ruleClassName;
    }

    protected IllegalArgumentException illegalArgumentException(String msg) throws IllegalArgumentException {
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.resolveClassName(), (CharSequence)" "), (CharSequence)msg));
    }

    protected IllegalArgumentException illegalArgumentException(String msg, Throwable cause) throws IllegalArgumentException {
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.resolveClassName(), (CharSequence)" "), (CharSequence)msg), cause);
    }

    protected EnforcerRuleException fail(String message) throws EnforcerRuleException {
        throw (Throwable)new EnforcerRuleException(this.getClass(), message);
    }

    protected EnforcerRuleException fail(String message, Exception cause) throws EnforcerRuleException {
        throw (Throwable)new EnforcerRuleException(this.getClass(), message, cause);
    }

    protected EnforcerRuleException fail(Exception cause) throws EnforcerRuleException {
        throw (Throwable)new EnforcerRuleException(this.getClass(), (Throwable)cause);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractEnforcerRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    public final Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public final Property<EnforcerLevel> getEnforcerLevel() {
        return this.enforcerLevel;
    }
}

