/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.ext.StringExtKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011J\u001a\u0010\u0013\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015J\u001d\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/koin/core/registry/PropertyRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_values", "", "", "close", "", "deleteProperty", "key", "getProperty", "loadEnvironmentProperties", "loadPropertiesFromFile", "fileName", "readDataFromFile", "Ljava/util/Properties;", "content", "saveProperties", "properties", "", "saveProperty", "value", "saveProperty$koin_core", "koin-core"})
public final class PropertyRegistry {
    private final Map<String, String> _values;
    private final Koin _koin;

    public final void saveProperties(@NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load " + properties.size() + " properties");
        }
        this._values.putAll(properties);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveProperties(@NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load " + properties.size() + " properties");
        }
        Map map = MapsKt.toMap((Map)properties);
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        }
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$k$v;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$k$v;
            bl3 = false;
            String v = (String)entry.getValue();
            this.saveProperty$koin_core((String)k, StringExtKt.quoted(v));
        }
    }

    public final void saveProperty$koin_core(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._values.put(key, value);
    }

    public final void deleteProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this._values.remove(key);
    }

    @Nullable
    public final String getProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this._values.get(key);
    }

    public final void loadPropertiesFromFile(@NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load properties from " + fileName);
        }
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = new String(byArray, charset);
        } else {
            string = content = null;
        }
        if (content != null) {
            if (this._koin.get_logger().isAt(Level.INFO)) {
                this._koin.get_logger().info("loaded properties from file:'" + fileName + '\'');
            }
        } else {
            throw (Throwable)new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = this.readDataFromFile(content);
        this.saveProperties(properties);
    }

    private final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public final void loadEnvironmentProperties() {
        Properties sysProperties;
        if (this._koin.get_logger().isAt(Level.DEBUG)) {
            this._koin.get_logger().debug("load properties from environment");
        }
        Properties properties = sysProperties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"sysProperties");
        this.saveProperties(properties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"System.getenv()");
        Map<String, String> map2 = map;
        boolean bl = false;
        Properties properties2 = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties3 = properties2;
        boolean bl4 = false;
        properties3.putAll(map2);
        Properties sysEnvProperties = properties2;
        this.saveProperties(sysEnvProperties);
    }

    public final void close() {
        this._values.clear();
    }

    public PropertyRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._values = new ConcurrentHashMap();
    }
}

