/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.context;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.context.KoinContext;
import org.koin.core.error.KoinAppAlreadyStartedException;
import org.koin.core.module.Module;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fJ-\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00012\u001b\u0010\u0012\u001a\u0017\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u0013j\u0002`\u0014\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\bH\u0016J\u0006\u0010\u0017\u001a\u00020\bJ\u0014\u0010\u0018\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/koin/core/context/GlobalContext;", "Lorg/koin/core/context/KoinContext;", "()V", "_koin", "Lorg/koin/core/Koin;", "get", "getOrNull", "loadKoinModules", "", "modules", "", "Lorg/koin/core/module/Module;", "module", "register", "koinApplication", "Lorg/koin/core/KoinApplication;", "startKoin", "koinContext", "appDeclaration", "Lkotlin/Function1;", "Lorg/koin/dsl/KoinAppDeclaration;", "Lkotlin/ExtensionFunctionType;", "stop", "stopKoin", "unloadKoinModules", "koin-core"})
public final class GlobalContext
implements KoinContext {
    private static Koin _koin;
    public static final GlobalContext INSTANCE;

    @Override
    @NotNull
    public Koin get() {
        Koin koin = _koin;
        if (koin == null) {
            String string = "KoinApplication has not been started";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return koin;
    }

    @Override
    @Nullable
    public Koin getOrNull() {
        return _koin;
    }

    @Override
    public void register(@NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"koinApplication");
        if (_koin != null) {
            throw (Throwable)new KoinAppAlreadyStartedException("A Koin Application has already been started");
        }
        _koin = koinApplication.getKoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            Koin koin = _koin;
            if (koin != null) {
                koin.close();
            }
            _koin = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KoinApplication startKoin(@NotNull KoinContext koinContext, @NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter((Object)koinContext, (String)"koinContext");
        Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"koinApplication");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            koinContext.register(koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    public static /* synthetic */ KoinApplication startKoin$default(GlobalContext globalContext, KoinContext koinContext, KoinApplication koinApplication, int n, Object object) {
        if ((n & 1) != 0) {
            koinContext = INSTANCE;
        }
        return globalContext.startKoin(koinContext, koinApplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KoinApplication startKoin(@NotNull KoinContext koinContext, @NotNull Function1<? super KoinApplication, Unit> appDeclaration) {
        Intrinsics.checkNotNullParameter((Object)koinContext, (String)"koinContext");
        Intrinsics.checkNotNullParameter(appDeclaration, (String)"appDeclaration");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            KoinApplication koinApplication = KoinApplication.Companion.init();
            koinContext.register(koinApplication);
            appDeclaration.invoke((Object)koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    public static /* synthetic */ KoinApplication startKoin$default(GlobalContext globalContext, KoinContext koinContext, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            koinContext = INSTANCE;
        }
        return globalContext.startKoin(koinContext, (Function1<? super KoinApplication, Unit>)function1);
    }

    public final void stopKoin() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadKoinModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            INSTANCE.get().loadModules(CollectionsKt.listOf((Object)module));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadKoinModules(@NotNull List<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            INSTANCE.get().loadModules(modules2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unloadKoinModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            INSTANCE.get().unloadModules(CollectionsKt.listOf((Object)module));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unloadKoinModules(@NotNull List<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        GlobalContext globalContext = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (globalContext) {
            boolean bl3 = false;
            INSTANCE.get().unloadModules(modules2);
            Unit unit = Unit.INSTANCE;
        }
    }

    private GlobalContext() {
    }

    static {
        GlobalContext globalContext;
        INSTANCE = globalContext = new GlobalContext();
    }
}

