/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.instance;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.bean.BeanDefinition;
import org.koin.core.bean.BeanRegistry;
import org.koin.core.scope.Scope;
import org.koin.error.BeanDefinitionException;
import org.koin.error.BeanInstanceCreationException;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014J!\u0010\u0015\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00180\u0017\"\u0004\b\u0000\u0010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ'\u0010\u0019\u001a\u00020\r\"\u0004\b\u0000\u0010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u001a\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/koin/core/instance/InstanceFactory;", "", "beanRegistry", "Lorg/koin/core/bean/BeanRegistry;", "(Lorg/koin/core/bean/BeanRegistry;)V", "getBeanRegistry", "()Lorg/koin/core/bean/BeanRegistry;", "instances", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/koin/core/bean/BeanDefinition;", "getInstances", "()Ljava/util/concurrent/ConcurrentHashMap;", "clear", "", "createInstance", "T", "def", "(Lorg/koin/core/bean/BeanDefinition;)Ljava/lang/Object;", "dropAllInstances", "definitions", "", "findInstance", "retrieveInstance", "Lkotlin/Pair;", "", "saveInstance", "instance", "(Lorg/koin/core/bean/BeanDefinition;Ljava/lang/Object;)V", "koin-core"})
public final class InstanceFactory {
    @NotNull
    private final ConcurrentHashMap<BeanDefinition<?>, Object> instances;
    @NotNull
    private final BeanRegistry beanRegistry;

    @NotNull
    public final ConcurrentHashMap<BeanDefinition<?>, Object> getInstances() {
        return this.instances;
    }

    @NotNull
    public final <T> Pair<T, Boolean> retrieveInstance(@NotNull BeanDefinition<?> def) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull(def, (String)"def");
        if (def.isNotASingleton()) {
            pair = new Pair(this.createInstance(def), (Object)true);
        } else {
            boolean created;
            T found = this.findInstance(def);
            T t = found;
            if (t == null) {
                t = this.createInstance(def);
            }
            T instance = t;
            boolean bl = created = found == null;
            if (created) {
                this.saveInstance(def, instance);
            }
            pair = new Pair(instance, (Object)created);
        }
        return pair;
    }

    private final <T> void saveInstance(BeanDefinition<?> def, T instance) {
        Map map = this.instances;
        T t = instance;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
        }
        T t2 = t;
        map.put(def, t2);
    }

    private final <T> T findInstance(BeanDefinition<?> def) {
        Object object;
        Object v0;
        block4: {
            Iterable $receiver$iv = this.instances.keySet();
            for (Object element$iv : $receiver$iv) {
                BeanDefinition it = (BeanDefinition)element$iv;
                if (!Intrinsics.areEqual((Object)it, def)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        BeanDefinition existingClass = v0;
        if (existingClass != null) {
            object = this.instances.get(existingClass);
            if (!(object instanceof Object)) {
                object = null;
            }
        } else {
            object = null;
        }
        return (T)object;
    }

    private final <T> T createInstance(BeanDefinition<?> def) {
        Scope scope = this.beanRegistry.getScopeForDefinition(def);
        if (scope == null) {
            throw (Throwable)new BeanDefinitionException("Can't create bean " + def + " in : " + scope + " -- Scope has not been declared");
        }
        try {
            Object object = def.getDefinition().invoke();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            Object instance = object;
            return (T)instance;
        }
        catch (Throwable e) {
            throw (Throwable)new BeanInstanceCreationException("Can't create bean " + def + " due to error :\n\t" + e);
        }
    }

    public final void dropAllInstances(@NotNull List<? extends BeanDefinition<?>> definitions) {
        Intrinsics.checkParameterIsNotNull(definitions, (String)"definitions");
        Iterable $receiver$iv = definitions;
        for (Object element$iv : $receiver$iv) {
            BeanDefinition it = (BeanDefinition)element$iv;
            this.instances.remove(it);
        }
    }

    public final void clear() {
        this.instances.clear();
    }

    @NotNull
    public final BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public InstanceFactory(@NotNull BeanRegistry beanRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)beanRegistry, (String)"beanRegistry");
        this.beanRegistry = beanRegistry;
        this.instances = new ConcurrentHashMap();
    }
}

