/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.connector;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.connector.GitHubConnectorRequest;

public abstract class GitHubConnectorResponse
implements Closeable {
    private static final Comparator<String> nullableCaseInsensitiveComparator = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
    private final int statusCode;
    @Nonnull
    private final GitHubConnectorRequest request;
    @Nonnull
    private final Map<String, List<String>> headers;

    protected GitHubConnectorResponse(@Nonnull GitHubConnectorRequest request, int statusCode, @Nonnull Map<String, List<String>> headers) {
        this.request = request;
        this.statusCode = statusCode;
        TreeMap caseInsensitiveMap = new TreeMap(nullableCaseInsensitiveComparator);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            caseInsensitiveMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        this.headers = Collections.unmodifiableMap(caseInsensitiveMap);
    }

    @CheckForNull
    public String header(String name) {
        String result = null;
        if (this.headers.containsKey(name)) {
            result = this.headers.get(name).get(0);
        }
        return result;
    }

    @Nonnull
    public abstract InputStream bodyStream() throws IOException;

    @Nonnull
    public GitHubConnectorRequest request() {
        return this.request;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Unmodifiable map of unmodifiable lists")
    public Map<String, List<String>> allHeaders() {
        return this.headers;
    }

    protected InputStream wrapStream(InputStream stream) throws IOException {
        String encoding = this.header("Content-Encoding");
        if (encoding == null || stream == null) {
            return stream;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(stream);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    public final int parseInt(String name) throws NumberFormatException {
        try {
            String headerValue = this.header(name);
            return Integer.parseInt(headerValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(name + ": " + e.getMessage());
        }
    }

    public static abstract class ByteArrayResponse
    extends GitHubConnectorResponse {
        private boolean inputStreamRead = false;
        private byte[] inputBytes = null;
        private boolean isClosed = false;

        protected ByteArrayResponse(@Nonnull GitHubConnectorRequest request, int statusCode, @Nonnull Map<String, List<String>> headers) {
            super(request, statusCode, headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public InputStream bodyStream() throws IOException {
            if (this.isClosed) {
                throw new IOException("Response is closed");
            }
            ByteArrayResponse byteArrayResponse = this;
            synchronized (byteArrayResponse) {
                if (!this.inputStreamRead) {
                    InputStream rawStream = this.rawBodyStream();
                    try (InputStream stream = this.wrapStream(rawStream);){
                        if (stream != null) {
                            this.inputBytes = IOUtils.toByteArray((InputStream)stream);
                        }
                    }
                    this.inputStreamRead = true;
                }
            }
            if (this.inputBytes == null) {
                throw new IOException("Response body missing, stream null");
            }
            return new ByteArrayInputStream(this.inputBytes);
        }

        @CheckForNull
        protected abstract InputStream rawBodyStream() throws IOException;

        @Override
        public void close() throws IOException {
            this.isClosed = true;
            this.inputBytes = null;
        }
    }
}

