/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.internal.EnumUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHRepositoryRule
extends GitHubInteractiveObject {
    private Map<String, JsonNode> parameters;
    private long rulesetId;
    private String rulesetSource;
    private String rulesetSourceType;
    private String type;

    public <T> Optional<T> getParameter(Parameter<T> parameter) throws IOException {
        if (this.parameters == null) {
            return Optional.empty();
        }
        JsonNode jsonNode = this.parameters.get(parameter.getKey());
        if (jsonNode == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(parameter.apply(jsonNode, this.root()));
    }

    public long getRulesetId() {
        return this.rulesetId;
    }

    public String getRulesetSource() {
        return this.rulesetSource;
    }

    public RulesetSourceType getRulesetSourceType() {
        return EnumUtils.getEnumOrDefault(RulesetSourceType.class, this.rulesetSourceType, RulesetSourceType.UNKNOWN);
    }

    public Type getType() {
        return EnumUtils.getEnumOrDefault(Type.class, this.type, Type.UNKNOWN);
    }

    public static abstract class Parameter<T> {
        private final String key;

        protected Parameter(String key) {
            this.key = key;
        }

        T apply(JsonNode jsonNode, GitHub root) throws IOException {
            if (jsonNode == null) {
                return null;
            }
            return (T)GitHubClient.getMappingObjectReader(root).forType(this.getType()).readValue(jsonNode);
        }

        String getKey() {
            return this.key;
        }

        abstract TypeReference<T> getType();
    }

    public static enum RulesetSourceType {
        ORGANIZATION,
        REPOSITORY,
        UNKNOWN;

    }

    public static enum Type {
        BRANCH_NAME_PATTERN,
        CODE_SCANNING,
        COMMITTER_EMAIL_PATTERN,
        COMMIT_AUTHOR_EMAIL_PATTERN,
        COMMIT_MESSAGE_PATTERN,
        CREATION,
        DELETION,
        NON_FAST_FORWARD,
        PULL_REQUEST,
        REQUIRED_DEPLOYMENTS,
        REQUIRED_LINEAR_HISTORY,
        REQUIRED_SIGNATURES,
        REQUIRED_STATUS_CHECKS,
        TAG_NAME_PATTERN,
        UNKNOWN,
        UPDATE,
        WORKFLOWS;

    }

    public static class WorkflowFileReference {
        private String path;
        private String ref;
        private long repositoryId;
        private String sha;

        public String getPath() {
            return this.path;
        }

        public String getRef() {
            return this.ref;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class StringParameter
    extends Parameter<String> {
        public StringParameter(String key) {
            super(key);
        }

        @Override
        TypeReference<String> getType() {
            return new TypeReference<String>(){};
        }
    }

    public static class StatusCheckConfiguration {
        private String context;
        private Integer integrationId;

        public String getContext() {
            return this.context;
        }

        public Integer getIntegrationId() {
            return this.integrationId;
        }
    }

    public static enum SecurityAlertsThreshold {
        ALL,
        CRITICAL,
        HIGH_OR_HIGHER,
        MEDIUM_OR_HIGHER,
        NONE;

    }

    public static interface Parameters {
        public static final ListParameter<CodeScanningTool> CODE_SCANNING_TOOLS = new ListParameter<CodeScanningTool>("code_scanning_tools"){

            @Override
            TypeReference<List<CodeScanningTool>> getType() {
                return new TypeReference<List<CodeScanningTool>>(){};
            }
        };
        public static final BooleanParameter DISMISS_STALE_REVIEWS_ON_PUSH = new BooleanParameter("dismiss_stale_reviews_on_push");
        public static final StringParameter NAME = new StringParameter("name");
        public static final BooleanParameter NEGATE = new BooleanParameter("negate");
        public static final Parameter<Operator> OPERATOR = new Parameter<Operator>("operator"){

            @Override
            TypeReference<Operator> getType() {
                return new TypeReference<Operator>(){};
            }
        };
        public static final StringParameter REGEX = new StringParameter("regex");
        public static final IntegerParameter REQUIRED_APPROVING_REVIEW_COUNT = new IntegerParameter("required_approving_review_count");
        public static final ListParameter<String> REQUIRED_DEPLOYMENT_ENVIRONMENTS = new ListParameter<String>("required_deployment_environments"){

            @Override
            TypeReference<List<String>> getType() {
                return new TypeReference<List<String>>(){};
            }
        };
        public static final BooleanParameter REQUIRED_REVIEW_THREAD_RESOLUTION = new BooleanParameter("required_review_thread_resolution");
        public static final ListParameter<StatusCheckConfiguration> REQUIRED_STATUS_CHECKS = new ListParameter<StatusCheckConfiguration>("required_status_checks"){

            @Override
            TypeReference<List<StatusCheckConfiguration>> getType() {
                return new TypeReference<List<StatusCheckConfiguration>>(){};
            }
        };
        public static final BooleanParameter REQUIRE_CODE_OWNER_REVIEW = new BooleanParameter("require_code_owner_review");
        public static final BooleanParameter REQUIRE_LAST_PUSH_APPROVAL = new BooleanParameter("require_last_push_approval");
        public static final BooleanParameter STRICT_REQUIRED_STATUS_CHECKS_POLICY = new BooleanParameter("strict_required_status_checks_policy");
        public static final BooleanParameter UPDATE_ALLOWS_FETCH_AND_MERGE = new BooleanParameter("update_allows_fetch_and_merge");
        public static final ListParameter<WorkflowFileReference> WORKFLOWS = new ListParameter<WorkflowFileReference>("workflows"){

            @Override
            TypeReference<List<WorkflowFileReference>> getType() {
                return new TypeReference<List<WorkflowFileReference>>(){};
            }
        };
    }

    public static enum Operator {
        CONTAINS,
        ENDS_WITH,
        REGEX,
        STARTS_WITH;

    }

    public static abstract class ListParameter<T>
    extends Parameter<List<T>> {
        public ListParameter(String key) {
            super(key);
        }
    }

    public static class IntegerParameter
    extends Parameter<Integer> {
        public IntegerParameter(String key) {
            super(key);
        }

        @Override
        TypeReference<Integer> getType() {
            return new TypeReference<Integer>(){};
        }
    }

    public static class CodeScanningTool {
        private AlertsThreshold alertsThreshold;
        private SecurityAlertsThreshold securityAlertsThreshold;
        private String tool;

        public AlertsThreshold getAlertsThreshold() {
            return this.alertsThreshold;
        }

        public SecurityAlertsThreshold getSecurityAlertsThreshold() {
            return this.securityAlertsThreshold;
        }

        public String getTool() {
            return this.tool;
        }
    }

    public static class BooleanParameter
    extends Parameter<Boolean> {
        public BooleanParameter(String key) {
            super(key);
        }

        @Override
        TypeReference<Boolean> getType() {
            return new TypeReference<Boolean>(){};
        }
    }

    public static enum AlertsThreshold {
        ALL,
        ERRORS,
        ERRORS_AND_WARNINGS,
        NONE;

    }
}

