/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewCommentReactions;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHPullRequestReviewComment
extends GHObject
implements Reactable {
    private GHCommentAuthorAssociation authorAssociation;
    private String body;
    private String bodyHtml;
    private String bodyText;
    private String commitId;
    private String diffHunk;
    private String htmlUrl;
    private long inReplyToId = -1L;
    private int line = -1;
    private String originalCommitId;
    private int originalLine = -1;
    private int originalPosition = -1;
    private Integer originalStartLine = -1;
    private String path;
    private int position = -1;
    private Long pullRequestReviewId = -1L;
    private String pullRequestUrl;
    private GHPullRequestReviewCommentReactions reactions;
    private String side;
    private Integer startLine = -1;
    private String startSide;
    private GHUser user;
    GHPullRequest owner;

    @Override
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @Override
    public void deleteReaction(GHReaction reaction) throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "reactions", String.valueOf(reaction.getId()))).send();
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return this.authorAssociation;
    }

    public String getBody() {
        return this.body;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getDiffHunk() {
        return this.diffHunk;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @CheckForNull
    public long getInReplyToId() {
        return this.inReplyToId;
    }

    public int getLine() {
        return this.line;
    }

    public String getOriginalCommitId() {
        return this.originalCommitId;
    }

    public int getOriginalLine() {
        return this.originalLine;
    }

    public int getOriginalPosition() {
        return this.originalPosition;
    }

    public int getOriginalStartLine() {
        return this.originalStartLine != null ? this.originalStartLine : -1;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getPath() {
        return this.path;
    }

    @CheckForNull
    public int getPosition() {
        return this.position;
    }

    public Long getPullRequestReviewId() {
        return this.pullRequestReviewId != null ? this.pullRequestReviewId : -1L;
    }

    public URL getPullRequestUrl() {
        return GitHubClient.parseURL(this.pullRequestUrl);
    }

    public GHPullRequestReviewCommentReactions getReactions() {
        return this.reactions;
    }

    public Side getSide() {
        return Side.from(this.side);
    }

    public int getStartLine() {
        return this.startLine != null ? this.startLine : -1;
    }

    public Side getStartSide() {
        return Side.from(this.startSide);
    }

    public GHUser getUser() throws IOException {
        return this.owner.root().getUser(this.user.getLogin());
    }

    @Override
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> this.owner.root());
    }

    public GHPullRequestReviewComment reply(String body) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).withUrlPath(this.getApiRoute(true) + "/replies", new String[0])).fetch(GHPullRequestReviewComment.class).wrapUp(this.owner);
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiRoute(), new String[0])).fetchInto(this);
        this.body = body;
    }

    protected String getApiRoute() {
        return this.getApiRoute(false);
    }

    protected String getApiRoute(boolean includePullNumber) {
        return "/repos/" + this.owner.getRepository().getFullName() + "/pulls" + (String)(includePullNumber ? "/" + this.owner.getNumber() : "") + "/comments/" + this.getId();
    }

    GHPullRequestReviewComment wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    public static enum Side {
        LEFT,
        RIGHT,
        UNKNOWN;


        public static Side from(String value) {
            return EnumUtils.getEnumOrDefault(Side.class, value, UNKNOWN);
        }
    }
}

