/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBridgeAdapterObject;

abstract class GitHubInteractiveObject
extends GitHubBridgeAdapterObject {
    @JacksonInject
    @CheckForNull
    private final transient GitHub root;

    GitHubInteractiveObject() {
        this.root = null;
    }

    GitHubInteractiveObject(GitHub root) {
        this.root = root;
    }

    @NonNull
    GitHub root() {
        return Objects.requireNonNull(this.root, "The root GitHub reference for this instance is null. Probably caused by deserializing this class without using a GitHub instance. If you must do this, use the MappingObjectReader from GitHub.getMappingObjectReader().");
    }

    boolean isOffline() {
        return this.root == null || this.root.isOffline();
    }
}

