/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.SkipFromToString;
import org.kohsuke.github.connector.GitHubConnectorResponse;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public abstract class GHObject
extends GitHubInteractiveObject {
    protected transient Map<String, List<String>> responseHeaderFields;
    private String url;
    private long id;
    private String nodeId;
    private String createdAt;
    private String updatedAt;
    private static final ToStringStyle TOSTRING_STYLE = new ToStringStyle(){
        {
            this.setUseShortClassName(true);
        }

        public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
            if (fieldName.contains("_")) {
                return;
            }
            if (value instanceof GHObject) {
                return;
            }
            if (value instanceof GitHub) {
                return;
            }
            super.append(buffer, fieldName, value, fullDetail);
        }
    };

    GHObject() {
    }

    @JacksonInject
    protected void setResponseHeaderFields(@CheckForNull GitHubConnectorResponse connectorResponse) {
        if (connectorResponse != null) {
            this.responseHeaderFields = connectorResponse.allHeaders();
        }
    }

    @CheckForNull
    @Deprecated
    public Map<String, List<String>> getResponseHeaderFields() {
        return GitHubClient.unmodifiableMapOrNull(this.responseHeaderFields);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCreatedAt() throws IOException {
        return GitHubClient.parseInstant(this.createdAt);
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getUpdatedAt() throws IOException {
        return GitHubClient.parseInstant(this.updatedAt);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, TOSTRING_STYLE, null, null, false, false){

            protected boolean accept(Field field) {
                return super.accept(field) && !field.isAnnotationPresent(SkipFromToString.class);
            }
        }.toString();
    }
}

