/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHDiscussionBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHDiscussion
extends GHObject {
    private GHTeam team;
    private long number;
    private String body;
    private String title;
    private String htmlUrl;
    @JsonProperty(value="private")
    private boolean isPrivate;

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    GHDiscussion wrapUp(GHTeam team) {
        this.team = team;
        return this;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHTeam getTeam() {
        return this.team;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public long getNumber() {
        return this.number;
    }

    @Override
    public long getId() {
        return this.getNumber();
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    static Creator create(GHTeam team) {
        return new Creator(team);
    }

    static GHDiscussion read(GHTeam team, long discussionNumber) throws IOException {
        return ((Requester)team.root().createRequest().setRawUrlPath(GHDiscussion.getRawUrlPath(team, discussionNumber))).fetch(GHDiscussion.class).wrapUp(team);
    }

    static PagedIterable<GHDiscussion> readAll(GHTeam team) {
        return ((Requester)team.root().createRequest().setRawUrlPath(GHDiscussion.getRawUrlPath(team, null))).toIterable(GHDiscussion[].class, item -> item.wrapUp(team));
    }

    public Updater update() {
        return new Updater(this);
    }

    public Setter set() {
        return new Setter(this);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.team.root().createRequest().method("DELETE")).setRawUrlPath(GHDiscussion.getRawUrlPath(this.team, this.number))).send();
    }

    private static String getRawUrlPath(@Nonnull GHTeam team, @CheckForNull Long discussionNumber) {
        return team.getUrl().toString() + "/discussions" + (String)(discussionNumber == null ? "" : "/" + discussionNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHDiscussion that = (GHDiscussion)o;
        return this.number == that.number && Objects.equals(this.getUrl(), that.getUrl()) && Objects.equals(this.team, that.team) && Objects.equals(this.body, that.body) && Objects.equals(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hash(this.team, this.number, this.body, this.title);
    }

    public static class Creator
    extends GHDiscussionBuilder<Creator> {
        private Creator(@Nonnull GHTeam team) {
            super(Creator.class, team, null);
            ((Requester)this.requester.method("POST")).setRawUrlPath(GHDiscussion.getRawUrlPath(team, null));
        }

        @Nonnull
        public Creator private_(boolean value) throws IOException {
            return (Creator)this.with("private", value);
        }
    }

    public static class Updater
    extends GHDiscussionBuilder<Updater> {
        private Updater(@Nonnull GHDiscussion base) {
            super(Updater.class, base.team, base);
            ((Requester)this.requester.method("PATCH")).setRawUrlPath(base.getUrl().toString());
        }
    }

    public static class Setter
    extends GHDiscussionBuilder<GHDiscussion> {
        private Setter(@Nonnull GHDiscussion base) {
            super(GHDiscussion.class, base.team, base);
            ((Requester)this.requester.method("PATCH")).setRawUrlPath(base.getUrl().toString());
        }
    }
}

