/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kohsuke.github.GHAppCreateTokenBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHMarketplaceAccountPlan;
import org.kohsuke.github.GHMarketplacePlanForAccountBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySelection;
import org.kohsuke.github.GHTargetType;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SearchResult;
import org.kohsuke.github.internal.EnumUtils;

public class GHAppInstallation
extends GHObject {
    private GHUser account;
    @JsonProperty(value="access_tokens_url")
    private String accessTokenUrl;
    @JsonProperty(value="repositories_url")
    private String repositoriesUrl;
    @JsonProperty(value="app_id")
    private long appId;
    @JsonProperty(value="target_id")
    private long targetId;
    @JsonProperty(value="target_type")
    private GHTargetType targetType;
    private Map<String, GHPermissionType> permissions;
    private List<String> events;
    @JsonProperty(value="single_file_name")
    private String singleFileName;
    @JsonProperty(value="repository_selection")
    private GHRepositorySelection repositorySelection;
    private String htmlUrl;
    private String suspendedAt;
    private GHUser suspendedBy;

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getAccount() {
        return this.account;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getRepositoriesUrl() {
        return this.repositoriesUrl;
    }

    @Deprecated
    public PagedSearchIterable<GHRepository> listRepositories() {
        GitHubRequest request = ((Requester)this.root().createRequest().withUrlPath("/installation/repositories", new String[0])).build();
        return new PagedSearchIterable<GHRepository>(this.root(), request, GHAppInstallationRepositoryResult.class);
    }

    public long getAppId() {
        return this.appId;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public GHTargetType getTargetType() {
        return this.targetType;
    }

    public Map<String, GHPermissionType> getPermissions() {
        return Collections.unmodifiableMap(this.permissions);
    }

    public List<GHEvent> getEvents() {
        return this.events.stream().map(e -> EnumUtils.getEnumOrDefault(GHEvent.class, e, GHEvent.UNKNOWN)).collect(Collectors.toList());
    }

    public String getSingleFileName() {
        return this.singleFileName;
    }

    public GHRepositorySelection getRepositorySelection() {
        return this.repositorySelection;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getSuspendedAt() {
        return GitHubClient.parseInstant(this.suspendedAt);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getSuspendedBy() {
        return this.suspendedBy;
    }

    public void deleteInstallation() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(String.format("/app/installations/%d", this.getId()), new String[0])).send();
    }

    @Deprecated
    public GHAppCreateTokenBuilder createToken(Map<String, GHPermissionType> permissions) {
        return this.createToken().permissions(permissions);
    }

    public GHAppCreateTokenBuilder createToken() {
        return new GHAppCreateTokenBuilder(this.root(), String.format("/app/installations/%d/access_tokens", this.getId()));
    }

    public GHMarketplaceAccountPlan getMarketplaceAccount() throws IOException {
        return new GHMarketplacePlanForAccountBuilder(this.root(), this.account.getId()).createRequest();
    }

    private static class GHAppInstallationRepositoryResult
    extends SearchResult<GHRepository> {
        private GHRepository[] repositories;

        private GHAppInstallationRepositoryResult() {
        }

        GHRepository[] getItems(GitHub root) {
            return this.repositories;
        }
    }
}

