/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.impl.AccessRestrictionFactory;
import org.kohsuke.accmod.impl.ErrorListener;
import org.kohsuke.accmod.impl.Location;
import org.kohsuke.accmod.impl.RestrictedElement;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Restrictions
extends ArrayList<AccessRestriction> {
    private final RestrictedElement target;
    public static final Restrictions NONE = new Restrictions(new RestrictedElement(){

        public boolean isInTheInspectedModule() {
            return false;
        }

        public String toString() {
            return "NONE";
        }
    });

    public Restrictions(RestrictedElement target, Collection<? extends AccessRestriction> c) {
        super(c);
        this.target = target;
    }

    public Restrictions(RestrictedElement target) {
        this.target = target;
    }

    public void usedAsSuperType(Location loc, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.usedAsSuperType(loc, this.target, errorListener);
        }
    }

    public void usedAsInterface(Location loc, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.usedAsInterface(loc, this.target, errorListener);
        }
    }

    public void instantiated(Location loc, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.instantiated(loc, this.target, errorListener);
        }
    }

    public void invoked(Location location, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.invoked(location, this.target, errorListener);
        }
    }

    public void read(Location location, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.read(location, this.target, errorListener);
        }
    }

    public void written(Location location, ErrorListener errorListener) {
        for (AccessRestriction ar : this) {
            ar.written(location, this.target, errorListener);
        }
    }

    static abstract class Parser
    extends AnnotationVisitor {
        private List<Type> restrictions = new ArrayList<Type>();
        private final RestrictedElement target;

        protected Parser(RestrictedElement target) {
            super(327680);
            this.target = target;
        }

        public void visit(String name, Object value) {
            this.restrictions.add((Type)value);
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public abstract void visitEnd();

        public Restrictions build(AccessRestrictionFactory f) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            Restrictions r = new Restrictions(this.target);
            for (Type t : this.restrictions) {
                r.add(f.get(t));
            }
            return r;
        }
    }
}

