/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.impl.Checker;
import org.kohsuke.accmod.impl.ErrorListener;
import org.kohsuke.accmod.impl.Location;

@Mojo(name="enforce", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class EnforcerMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(property="access-modifier-checker.skip", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="access-modifier-checker.failOnError", defaultValue="true")
    private boolean failOnError = true;
    @Parameter
    private Properties properties;

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "URLCONNECTION_SSRF_FD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "PATH_TRAVERSAL_IN", "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED", "NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping access modifier checks");
            return;
        }
        try {
            File outputDir = new File(this.project.getBuild().getOutputDirectory());
            ArrayList<URL> dependencies = new ArrayList<URL>();
            for (Artifact a : this.project.getArtifacts()) {
                dependencies.add(a.getFile().toURI().toURL());
            }
            URL outputURL = outputDir.toURI().toURL();
            dependencies.add(outputURL);
            final boolean[] failed = new boolean[1];
            Checker checker = new Checker(new URLClassLoader(dependencies.toArray(new URL[dependencies.size()]), ((Object)((Object)this)).getClass().getClassLoader()), new ErrorListener(){

                public void onError(Throwable t, Location loc, String msg) {
                    String locMsg = loc + " " + msg;
                    if (EnforcerMojo.this.failOnError) {
                        EnforcerMojo.this.getLog().error((CharSequence)locMsg, t);
                    } else {
                        EnforcerMojo.this.getLog().warn((CharSequence)locMsg, t);
                    }
                    failed[0] = true;
                }

                public void onWarning(Throwable t, Location loc, String msg) {
                    EnforcerMojo.this.getLog().warn((CharSequence)(loc + " " + msg), t);
                }
            }, this.properties != null ? this.properties : new Properties(), this.getLog());
            InputStream self = null;
            try {
                self = new URL(outputURL, "META-INF/services/annotations/" + Restricted.class.getName()).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (self != null) {
                checker.loadRestrictions(self, true);
            }
            checker.check(outputDir);
            if (failed[0]) {
                String message = "Access modifier checks failed. See the details above";
                if (this.failOnError) {
                    throw new MojoFailureException(message);
                }
                this.getLog().warn((CharSequence)message);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to enforce @Restricted constraints", (Exception)e);
        }
    }
}

