/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.accmod.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.accmod.AccessRestriction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.impl.AccessRestrictionFactory;
import org.kohsuke.accmod.impl.ErrorListener;
import org.kohsuke.accmod.impl.Location;
import org.kohsuke.accmod.impl.RestrictedElement;
import org.kohsuke.accmod.impl.Restrictions;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Checker {
    public final ClassLoader dependencies;
    private final ErrorListener errorListener;
    private final Properties properties;
    private final Map<String, Restrictions> restrictions = new HashMap<String, Restrictions>();
    private final AccessRestrictionFactory factory;
    private static final String RESTRICTED_DESCRIPTOR = Type.getDescriptor(Restricted.class);

    Checker(ClassLoader dependencies, ErrorListener errorListener, Properties properties) throws IOException {
        this.dependencies = dependencies;
        this.errorListener = errorListener;
        this.properties = properties;
        this.factory = new AccessRestrictionFactory(dependencies);
        this.loadAccessRestrictions();
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void check(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.check(c);
            }
            return;
        }
        if (f.getPath().endsWith(".class")) {
            this.checkClass(f);
        }
    }

    private void loadAccessRestrictions() throws IOException {
        Enumeration<URL> res = this.dependencies.getResources("META-INF/annotations/" + Restricted.class.getName());
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            this.loadRestrictions(url.openStream(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRestrictions(InputStream stream, final boolean isInTheInspectedModule) throws IOException {
        String className;
        if (stream == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        while ((className = r.readLine()) != null) {
            InputStream is = this.dependencies.getResourceAsStream(className.replace('.', '/') + ".class");
            if (is == null) {
                this.errorListener.onWarning(null, null, "Failed to find class file for " + className);
                continue;
            }
            try {
                new ClassReader(is).accept(new ClassVisitor(327680){
                    private String className;

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        this.className = name;
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return this.onAnnotationFor(this.className, desc);
                    }

                    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                        return new FieldVisitor(327680){

                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                return this.onAnnotationFor(className + '.' + name, desc);
                            }
                        };
                    }

                    public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                        return new MethodVisitor(327680){

                            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                                return this.onAnnotationFor(className + '.' + methodName + methodDesc, desc);
                            }
                        };
                    }

                    private AnnotationVisitor onAnnotationFor(final String keyName, String desc) {
                        if (RESTRICTED_DESCRIPTOR.equals(desc)) {
                            RestrictedElement target = new RestrictedElement(){

                                public boolean isInTheInspectedModule() {
                                    return isInTheInspectedModule;
                                }

                                public String toString() {
                                    return keyName;
                                }
                            };
                            return new Restrictions.Parser(target){

                                @Override
                                public void visitEnd() {
                                    try {
                                        Checker.this.restrictions.put(keyName, this.build(Checker.this.factory));
                                    }
                                    catch (ClassNotFoundException e) {
                                        this.failure(e);
                                    }
                                    catch (InstantiationException e) {
                                        this.failure(e);
                                    }
                                    catch (IllegalAccessException e) {
                                        this.failure(e);
                                    }
                                }

                                private void failure(Exception e) {
                                    Checker.this.errorListener.onError((Throwable)e, null, "Failed to load restrictions");
                                }
                            };
                        }
                        return null;
                    }
                }, 1);
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClass(File clazz) throws IOException {
        try (FileInputStream in = new FileInputStream(clazz);){
            ClassReader cr = new ClassReader((InputStream)in);
            cr.accept(new ClassVisitor(327680){
                private String className;
                private String methodName;
                private String methodDesc;
                private int line;
                private final Location currentLocation;
                {
                    this.currentLocation = new Location(){

                        public String getClassName() {
                            return className.replace('/', '.');
                        }

                        public String getMethodName() {
                            return methodName;
                        }

                        public String getMethodDescriptor() {
                            return methodDesc;
                        }

                        public int getLineNumber() {
                            return line;
                        }

                        public String toString() {
                            return className + ':' + line;
                        }

                        public ClassLoader getDependencyClassLoader() {
                            return Checker.this.dependencies;
                        }

                        public String getProperty(String key) {
                            return Checker.this.properties.getProperty(key);
                        }
                    };
                }

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.className = name;
                    if (superName != null) {
                        for (Restrictions r : Checker.this.getRestrictions(superName)) {
                            r.usedAsSuperType(this.currentLocation, Checker.this.errorListener);
                        }
                    }
                    if (interfaces != null) {
                        for (String intf : interfaces) {
                            for (Restrictions r : Checker.this.getRestrictions(intf)) {
                                r.usedAsInterface(this.currentLocation, Checker.this.errorListener);
                            }
                        }
                    }
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    this.methodName = name;
                    this.methodDesc = desc;
                    return new MethodVisitor(327680){

                        public void visitLineNumber(int _line, Label start) {
                            line = _line;
                        }

                        public void visitTypeInsn(int opcode, String type) {
                            switch (opcode) {
                                case 187: {
                                    for (Restrictions r : Checker.this.getRestrictions(type)) {
                                        r.instantiated(currentLocation, Checker.this.errorListener);
                                    }
                                    break;
                                }
                            }
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            for (Restrictions r : Checker.this.getRestrictions(owner + '.' + name + desc)) {
                                r.invoked(currentLocation, Checker.this.errorListener);
                            }
                        }

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            Iterable rs = Checker.this.getRestrictions(owner + '.' + name);
                            switch (opcode) {
                                case 178: 
                                case 180: {
                                    for (Restrictions r : rs) {
                                        r.read(currentLocation, Checker.this.errorListener);
                                    }
                                    break;
                                }
                                case 179: 
                                case 181: {
                                    for (Restrictions r : rs) {
                                        r.written(currentLocation, Checker.this.errorListener);
                                    }
                                    break;
                                }
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                        }
                    };
                }
            }, 4);
        }
    }

    private Iterable<Restrictions> getRestrictions(String keyName) {
        int newIdx;
        ArrayList<Restrictions> rs = new ArrayList<Restrictions>();
        Restrictions r = this.restrictions.get(keyName);
        if (r != null) {
            rs.add(r);
        }
        int idx = Integer.MAX_VALUE;
        while ((newIdx = keyName.lastIndexOf(46, idx)) != -1 || (newIdx = keyName.lastIndexOf(36, idx)) != -1) {
            idx = newIdx;
            r = this.restrictions.get(keyName = keyName.substring(0, idx));
            if (r == null) continue;
            ArrayList<AccessRestriction> applicable = new ArrayList<AccessRestriction>();
            for (AccessRestriction ar : r) {
                if (!ar.appliesToNested()) continue;
                applicable.add(ar);
            }
            if (applicable.isEmpty()) continue;
            rs.add(new Restrictions(r.target, applicable));
        }
        return rs;
    }
}

