/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.db.leveldb.jni;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.db.leveldb.LevelDB;
import org.kodein.db.leveldb.LevelDBFactory;
import org.kodein.db.leveldb.PlatformCloseable;
import org.kodein.db.leveldb.jni.Native;
import org.kodein.db.leveldb.jni.NativeBound;
import org.kodein.db.leveldb.jni.ReadBufferKt;
import org.kodein.memory.io.Allocation;
import org.kodein.memory.io.ByteBuffersKt;
import org.kodein.memory.io.Memory;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.Readable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0006#$%&'(B'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB;", "ptr", "", "optionsPtr", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "path", "", "(JJLorg/kodein/db/leveldb/LevelDB$Options;Ljava/lang/String;)V", "dbHandler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "getPath", "()Ljava/lang/String;", "beforeClose", "", "delete", "key", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/db/leveldb/LevelDB$WriteOptions;", "get", "Lorg/kodein/memory/io/Allocation;", "Lorg/kodein/db/leveldb/LevelDB$ReadOptions;", "newCursor", "Lorg/kodein/db/leveldb/LevelDB$Cursor;", "newSnapshot", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "newWriteBatch", "Lorg/kodein/db/leveldb/LevelDB$WriteBatch;", "put", "value", "release", "write", "batch", "Companion", "Cursor", "Factory", "NativeBytes", "Snapshot", "WriteBatch", "kodein-leveldb_release"})
public final class LevelDBJNI
extends NativeBound
implements LevelDB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long optionsPtr;
    @NotNull
    private final String path;
    @NotNull
    private final PlatformCloseable.Handler dbHandler;

    private LevelDBJNI(long ptr, long optionsPtr, LevelDB.Options options, String path) {
        super(ptr, "DB", null, options);
        this.optionsPtr = optionsPtr;
        this.path = path;
        this.dbHandler = new PlatformCloseable.Handler();
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    protected void beforeClose() {
        this.dbHandler.close();
    }

    public void put(@NotNull ReadMemory key, @NotNull ReadMemory value, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ByteBuffer directKey = ReadBufferKt.directByteBuffer(key);
        ByteBuffer directValue = ReadBufferKt.directByteBuffer(value);
        if (directKey != null && directValue != null) {
            Native.putBB(this.getNonZeroPtr(), directKey, directKey.limit(), directValue, directValue.limit(), options.getSync());
        } else if (directValue != null) {
            Native.putAB(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), directValue, directValue.limit(), options.getSync());
        } else if (directKey != null) {
            Native.putBA(this.getNonZeroPtr(), directKey, directKey.limit(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), value.getSize(), options.getSync());
        } else {
            Native.putAA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), value.getSize(), options.getSync());
        }
    }

    public void delete(@NotNull ReadMemory key, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ByteBuffer directKey = ReadBufferKt.directByteBuffer(key);
        if (directKey != null) {
            Native.deleteB(this.getNonZeroPtr(), directKey, directKey.limit(), options.getSync());
        } else {
            Native.deleteA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), options.getSync());
        }
    }

    public void write(@NotNull LevelDB.WriteBatch batch, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Native.write(this.getNonZeroPtr(), ((WriteBatch)batch).getNonZeroPtr(), options.getSync());
    }

    @Nullable
    public Allocation get(@NotNull ReadMemory key, @NotNull LevelDB.ReadOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ByteBuffer directKey = ReadBufferKt.directByteBuffer(key);
        long valuePtr = directKey != null ? Native.getB(this.getNonZeroPtr(), directKey, directKey.limit(), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot())) : Native.getA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot()));
        return valuePtr == 0L ? null : (Allocation)new NativeBytes(valuePtr, this.dbHandler, this.getOptions(), null, 8, null);
    }

    @NotNull
    public LevelDB.Cursor newCursor(@NotNull LevelDB.ReadOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new Cursor(Native.iteratorNew(this.getNonZeroPtr(), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot())), this.dbHandler, this.getOptions());
    }

    @NotNull
    public LevelDB.Snapshot newSnapshot() {
        long ptr = this.getNonZeroPtr();
        return new Snapshot(ptr, Native.snapshotNew(ptr), this.dbHandler, this.getOptions());
    }

    @NotNull
    public LevelDB.WriteBatch newWriteBatch() {
        return new WriteBatch(Native.INSTANCE.writeBatchNew(), this.dbHandler, this.getOptions());
    }

    @Override
    protected void release(long ptr) {
        Native.dbRelease(ptr);
        Native.optionsRelease(this.optionsPtr);
    }

    public /* synthetic */ LevelDBJNI(long ptr, long optionsPtr, LevelDB.Options options, String path, DefaultConstructorMarker $constructor_marker) {
        this(ptr, optionsPtr, options, path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Factory;", "Lorg/kodein/db/leveldb/LevelDBFactory;", "()V", "destroy", "", "path", "", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "open", "Lorg/kodein/db/leveldb/LevelDB;", "kodein-leveldb_release"})
    public static final class Factory
    implements LevelDBFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @NotNull
        public LevelDB open(@NotNull String path, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            long optionsPtr = Companion.newNativeOptions(options);
            try {
                return new LevelDBJNI(Native.dbOpen(path, optionsPtr, options.getRepairOnCorruption()), optionsPtr, options, path, null);
            }
            catch (Throwable e) {
                Native.optionsRelease(optionsPtr);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(@NotNull String path, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            long optionsPtr = Companion.newNativeOptions(options);
            try {
                Native.dbDestroy(path, optionsPtr);
            }
            finally {
                Native.optionsRelease(optionsPtr);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0003J\u0011\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J)\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J\u0011\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J\t\u0010\"\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010#\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0015H\u0096\u0001J)\u0010%\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010%\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020(H\u0096\u0001J!\u0010%\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010*\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010+\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0005H\u0096\u0001J\u0019\u0010,\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020!H\u0096\u0001J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0019\u0010.\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0015H\u0096\u0003J\u0019\u0010/\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0096\u0001J\b\u00100\u001a\u000201H\u0016R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$NativeBytes;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/memory/io/Allocation;", "Lorg/kodein/memory/io/Memory;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "memory", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;Lorg/kodein/memory/io/Memory;)V", "getMemory", "()Lorg/kodein/memory/io/Memory;", "size", "", "getSize", "()I", "fill", "", "byte", "", "get", "index", "getByte", "getBytes", "dst", "", "dstOffset", "length", "getInt", "getLong", "getShort", "", "internalMemory", "putByte", "value", "putBytes", "src", "srcOffset", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/memory/io/Readable;", "putInt", "putLong", "putShort", "release", "set", "slice", "toString", "", "kodein-leveldb_release"})
    private static final class NativeBytes
    extends NativeBound
    implements Allocation,
    Memory {
        @NotNull
        private final Memory memory;

        public NativeBytes(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options, @NotNull Memory memory) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
            super(ptr, "Value", handler, options);
            this.memory = memory;
        }

        public /* synthetic */ NativeBytes(long l, PlatformCloseable.Handler handler, LevelDB.Options options, Memory memory, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                memory = ByteBuffersKt.wrap((Memory.Companion)Memory.Companion, (ByteBuffer)Native.bufferNew(l));
            }
            this(l, handler, options, memory);
        }

        @NotNull
        public Memory getMemory() {
            return this.memory;
        }

        public void fill(byte by) {
            this.memory.fill(by);
        }

        public byte get(int index) {
            return this.memory.get(index);
        }

        public byte getByte(int index) {
            return this.memory.getByte(index);
        }

        public void getBytes(int index, @NotNull byte[] dst, int dstOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            this.memory.getBytes(index, dst, dstOffset, length);
        }

        public int getInt(int index) {
            return this.memory.getInt(index);
        }

        public long getLong(int index) {
            return this.memory.getLong(index);
        }

        public short getShort(int index) {
            return this.memory.getShort(index);
        }

        @NotNull
        public Memory internalMemory() {
            return this.memory.internalMemory();
        }

        public void putByte(int index, byte value) {
            this.memory.putByte(index, value);
        }

        public void putBytes(int index, @NotNull byte[] src, int srcOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.memory.putBytes(index, src, srcOffset, length);
        }

        public void putBytes(int index, @NotNull ReadMemory src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.memory.putBytes(index, src);
        }

        public void putBytes(int index, @NotNull Readable src, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.memory.putBytes(index, src, length);
        }

        public void putInt(int index, int value) {
            this.memory.putInt(index, value);
        }

        public void putLong(int index, long value) {
            this.memory.putLong(index, value);
        }

        public void putShort(int index, short value) {
            this.memory.putShort(index, value);
        }

        public void set(int index, byte value) {
            this.memory.set(index, value);
        }

        @NotNull
        public Memory slice(int index, int length) {
            return this.memory.slice(index, length);
        }

        public int getSize() {
            return this.memory.getSize();
        }

        @Override
        protected void release(long ptr) {
            Native.bufferRelease(ptr);
        }

        @NotNull
        public String toString() {
            return this.getMemory().toString();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$WriteBatch;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$WriteBatch;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "append", "", "source", "clear", "delete", "key", "Lorg/kodein/memory/io/ReadMemory;", "put", "value", "release", "kodein-leveldb_release"})
    private static final class WriteBatch
    extends NativeBound
    implements LevelDB.WriteBatch {
        public WriteBatch(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "WriteBatch", handler, options);
        }

        public void put(@NotNull ReadMemory key, @NotNull ReadMemory value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ByteBuffer directKey = ReadBufferKt.directByteBuffer(key);
            ByteBuffer directValue = ReadBufferKt.directByteBuffer(value);
            if (directKey != null && directValue != null) {
                Native.writeBatchPutBB(this.getNonZeroPtr(), directKey, directKey.limit(), directValue, directValue.limit());
            } else if (directValue != null) {
                Native.writeBatchPutAB(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), directValue, directValue.limit());
            } else if (directKey != null) {
                Native.writeBatchPutBA(this.getNonZeroPtr(), directKey, directKey.limit(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), value.getSize());
            } else {
                Native.writeBatchPutAA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), value.getSize());
            }
        }

        public void delete(@NotNull ReadMemory key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ByteBuffer directKey = ReadBufferKt.directByteBuffer(key);
            if (directKey != null) {
                Native.writeBatchDeleteB(this.getNonZeroPtr(), directKey, directKey.limit());
            } else {
                Native.writeBatchDeleteA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), key.getSize());
            }
        }

        public void clear() {
            Native.writeBatchClear(this.getNonZeroPtr());
        }

        public void append(@NotNull LevelDB.WriteBatch source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Native.writeBatchAppend(this.getNonZeroPtr(), ((WriteBatch)source).getNonZeroPtr());
        }

        @Override
        protected void release(long ptr) {
            Native.writeBatchRelease(ptr);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Snapshot;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "_dbPtr", "", "ptr", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JJLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "release", "", "kodein-leveldb_release"})
    private static final class Snapshot
    extends NativeBound
    implements LevelDB.Snapshot {
        private final long _dbPtr;

        public Snapshot(long _dbPtr, long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "Snapshot", handler, options);
            this._dbPtr = _dbPtr;
        }

        @Override
        protected void release(long ptr) {
            Native.snapshotRelease(this._dbPtr, ptr);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Cursor;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$Cursor;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "lens", "", "isValid", "", "next", "", "prev", "release", "seekTo", "target", "Lorg/kodein/memory/io/ReadMemory;", "seekToFirst", "seekToLast", "transientKey", "transientValue", "kodein-leveldb_release"})
    private static final class Cursor
    extends NativeBound
    implements LevelDB.Cursor {
        @NotNull
        private final int[] lens;

        public Cursor(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "Cursor", handler, options);
            Cursor cursor = this;
            int n = 0;
            int[] nArray = new int[2];
            while (n < 2) {
                int n2 = n++;
                nArray[n2] = -1;
            }
            cursor.lens = nArray;
        }

        public boolean isValid() {
            return this.lens[0] >= 0;
        }

        public void seekToFirst() {
            Native.iteratorSeekToFirst(this.getNonZeroPtr(), this.lens);
        }

        public void seekToLast() {
            Native.iteratorSeekToLast(this.getNonZeroPtr(), this.lens);
        }

        public void seekTo(@NotNull ReadMemory target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            ByteBuffer directTarget = ReadBufferKt.directByteBuffer(target);
            if (directTarget != null) {
                Native.iteratorSeekB(this.getNonZeroPtr(), directTarget, directTarget.limit(), this.lens);
            } else {
                Native.iteratorSeekA(this.getNonZeroPtr(), ReadBufferKt.array(target), ReadBufferKt.arrayOffset(target), target.getSize(), this.lens);
            }
        }

        public void next() {
            Native.iteratorNext(this.getNonZeroPtr(), this.lens);
        }

        public void prev() {
            Native.iteratorPrev(this.getNonZeroPtr(), this.lens);
        }

        @NotNull
        public ReadMemory transientKey() {
            return (ReadMemory)ByteBuffersKt.wrap((Memory.Companion)Memory.Companion, (ByteBuffer)Native.iteratorKey(this.getNonZeroPtr()));
        }

        @NotNull
        public ReadMemory transientValue() {
            return (ReadMemory)ByteBuffersKt.wrap((Memory.Companion)Memory.Companion, (ByteBuffer)Native.iteratorValue(this.getNonZeroPtr()));
        }

        @Override
        protected void release(long ptr) {
            Native.iteratorRelease(ptr);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Companion;", "", "()V", "newNativeOptions", "", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "snapshotPtr", "snapshot", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "kodein-leveldb_release"})
    public static final class Companion {
        private Companion() {
        }

        private final long newNativeOptions(LevelDB.Options options) {
            return Native.optionsNew(options.getPrintLogs(), options.getOpenPolicy().getCreateIfMissing(), options.getOpenPolicy().getErrorIfExists(), options.getParanoidChecks(), options.getWriteBufferSize(), options.getMaxOpenFiles(), options.getCacheSize(), options.getBlockSize(), options.getBlockRestartInterval(), options.getMaxFileSize(), options.getSnappyCompression(), options.getReuseLogs(), options.getBloomFilterBitsPerKey());
        }

        private final long snapshotPtr(LevelDB.Snapshot snapshot) {
            return snapshot != null ? ((Snapshot)snapshot).getNonZeroPtr() : 0L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

