/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.db.leveldb.jni;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.db.leveldb.LevelDB;
import org.kodein.db.leveldb.LevelDBException;
import org.kodein.db.leveldb.LevelDBFactory;
import org.kodein.db.leveldb.PlatformCloseable;
import org.kodein.db.leveldb.jni.Native;
import org.kodein.db.leveldb.jni.NativeBound;
import org.kodein.db.leveldb.jni.ReadBufferKt;
import org.kodein.memory.io.Allocation;
import org.kodein.memory.io.JvmNioKBuffer;
import org.kodein.memory.io.KBuffer;
import org.kodein.memory.io.KBufferJVMKt;
import org.kodein.memory.io.KBufferKt;
import org.kodein.memory.io.ReadMemory;
import org.kodein.memory.io.ReadMemoryKt;
import org.kodein.memory.io.Readable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0006#$%&'(B'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB;", "ptr", "", "optionsPtr", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "path", "", "(JJLorg/kodein/db/leveldb/LevelDB$Options;Ljava/lang/String;)V", "dbHandler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "getPath", "()Ljava/lang/String;", "beforeClose", "", "delete", "key", "Lorg/kodein/memory/io/ReadMemory;", "Lorg/kodein/db/leveldb/LevelDB$WriteOptions;", "get", "Lorg/kodein/memory/io/Allocation;", "Lorg/kodein/db/leveldb/LevelDB$ReadOptions;", "newCursor", "Lorg/kodein/db/leveldb/LevelDB$Cursor;", "newSnapshot", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "newWriteBatch", "Lorg/kodein/db/leveldb/LevelDB$WriteBatch;", "put", "value", "release", "write", "batch", "Companion", "Cursor", "Factory", "NativeBytes", "Snapshot", "WriteBatch", "kodein-leveldb_release"})
public final class LevelDBJNI
extends NativeBound
implements LevelDB {
    private final PlatformCloseable.Handler dbHandler;
    private final long optionsPtr;
    @NotNull
    private final String path;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void beforeClose() {
        this.dbHandler.close();
    }

    public void put(@NotNull ReadMemory key, @NotNull ReadMemory value, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JvmNioKBuffer directKey = ReadBufferKt.directJvmNioKBuffer(key);
        JvmNioKBuffer directValue = ReadBufferKt.directJvmNioKBuffer(value);
        if (directKey != null && directValue != null) {
            Native.putBB(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), directValue.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directValue)), directValue.getAvailable(), options.getSync());
        } else if (directValue != null) {
            Native.putAB(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), directValue.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directValue)), directValue.getAvailable(), options.getSync());
        } else if (directKey != null) {
            Native.putBA(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), ReadMemoryKt.getSize((ReadMemory)value), options.getSync());
        } else {
            Native.putAA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), ReadMemoryKt.getSize((ReadMemory)value), options.getSync());
        }
    }

    public void delete(@NotNull ReadMemory key, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JvmNioKBuffer directKey = ReadBufferKt.directJvmNioKBuffer(key);
        if (directKey != null) {
            Native.deleteB(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), options.getSync());
        } else {
            Native.deleteA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), options.getSync());
        }
    }

    public void write(@NotNull LevelDB.WriteBatch batch, @NotNull LevelDB.WriteOptions options) {
        Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Native.write(this.getNonZeroPtr(), ((WriteBatch)batch).getNonZeroPtr(), options.getSync());
    }

    @Nullable
    public Allocation get(@NotNull ReadMemory key, @NotNull LevelDB.ReadOptions options) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JvmNioKBuffer directKey = ReadBufferKt.directJvmNioKBuffer(key);
        long valuePtr = directKey != null ? Native.getB(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot())) : Native.getA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot()));
        return valuePtr == 0L ? null : (Allocation)new NativeBytes(valuePtr, this.dbHandler, this.getOptions(), null, 8, null);
    }

    @NotNull
    public LevelDB.Cursor newCursor(@NotNull LevelDB.ReadOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new Cursor(Native.iteratorNew(this.getNonZeroPtr(), options.getVerifyChecksums(), options.getFillCache(), LevelDBJNI.Companion.snapshotPtr(options.getSnapshot())), this.dbHandler, this.getOptions());
    }

    @NotNull
    public LevelDB.Snapshot newSnapshot() {
        long ptr = this.getNonZeroPtr();
        return new Snapshot(ptr, Native.snapshotNew(ptr), this.dbHandler, this.getOptions());
    }

    @NotNull
    public LevelDB.WriteBatch newWriteBatch() {
        return new WriteBatch(Native.writeBatchNew(), this.dbHandler, this.getOptions());
    }

    @Override
    protected void release(long ptr) {
        Native.dbRelease(ptr);
        Native.optionsRelease(this.optionsPtr);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    private LevelDBJNI(long ptr, long optionsPtr, LevelDB.Options options, String path) {
        super(ptr, "DB", null, options);
        this.optionsPtr = optionsPtr;
        this.path = path;
        this.dbHandler = new PlatformCloseable.Handler();
    }

    public /* synthetic */ LevelDBJNI(long ptr, long optionsPtr, LevelDB.Options options, String path, DefaultConstructorMarker $constructor_marker) {
        this(ptr, optionsPtr, options, path);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Factory;", "Lorg/kodein/db/leveldb/LevelDBFactory;", "()V", "destroy", "", "path", "", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "open", "Lorg/kodein/db/leveldb/LevelDB;", "kodein-leveldb_release"})
    public static final class Factory
    implements LevelDBFactory {
        @NotNull
        public static final Factory INSTANCE;

        @NotNull
        public LevelDB open(@NotNull String path, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            long optionsPtr = Companion.newNativeOptions(options);
            try {
                return new LevelDBJNI(Native.dbOpen(path, optionsPtr, options.getRepairOnCorruption()), optionsPtr, options, path, null);
            }
            catch (Throwable e) {
                Native.optionsRelease(optionsPtr);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(@NotNull String path, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            long optionsPtr = Companion.newNativeOptions(options);
            try {
                Native.dbDestroy(path, optionsPtr);
            }
            finally {
                Native.optionsRelease(optionsPtr);
            }
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u0096\u0001J\t\u0010 \u001a\u00020!H\u0096\u0001J\t\u0010\"\u001a\u00020!H\u0096\u0001J\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0096\u0003J\u0011\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0096\u0001J)\u0010'\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\u0011\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u00102\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u00103\u001a\u0002042\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\t\u00105\u001a\u00020\u0003H\u0096\u0001J\u0011\u0010\u0018\u001a\u00020!2\u0006\u00106\u001a\u00020\rH\u0096\u0001J\u0011\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020$H\u0096\u0001J!\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\u0019\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020<2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\u0011\u0010=\u001a\u00020!2\u0006\u00108\u001a\u00020,H\u0096\u0001J\u0011\u0010>\u001a\u00020!2\u0006\u00108\u001a\u00020.H\u0096\u0001J\u0011\u0010?\u001a\u00020!2\u0006\u00108\u001a\u000200H\u0096\u0001J\u0011\u0010@\u001a\u00020!2\u0006\u00108\u001a\u00020\rH\u0096\u0001J\u0011\u0010A\u001a\u00020!2\u0006\u00108\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010B\u001a\u00020!2\u0006\u00108\u001a\u000204H\u0096\u0001J\t\u0010C\u001a\u00020$H\u0096\u0001J!\u0010D\u001a\u00020!2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\t\u0010E\u001a\u00020,H\u0096\u0001J\t\u0010F\u001a\u00020.H\u0096\u0001J\t\u0010G\u001a\u000200H\u0096\u0001J\t\u0010H\u001a\u00020\rH\u0096\u0001J\t\u0010I\u001a\u00020\u0005H\u0096\u0001J\t\u0010J\u001a\u000204H\u0096\u0001J\t\u0010K\u001a\u00020\rH\u0096\u0001J!\u0010K\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\u0010\u0010L\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\t\u0010M\u001a\u00020!H\u0096\u0001J\u0019\u0010N\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020$H\u0096\u0003J\u0019\u0010O\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020$H\u0096\u0001J)\u0010P\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J)\u0010P\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u0010:\u001a\u00020Q2\u0006\u0010;\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\u0019\u0010R\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020,H\u0096\u0001J\u0019\u0010S\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020.H\u0096\u0001J\u0019\u0010T\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u000200H\u0096\u0001J\u0019\u0010U\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020\rH\u0096\u0001J\u0019\u0010V\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u00020\u0005H\u0096\u0001J\u0019\u0010W\u001a\u00020!2\u0006\u0010%\u001a\u00020\r2\u0006\u00108\u001a\u000204H\u0096\u0001J\u0011\u0010X\u001a\u00020\r2\u0006\u0010Y\u001a\u00020\rH\u0096\u0001J\t\u0010Z\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010Z\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0096\u0001J\b\u0010[\u001a\u00020\\H\u0016J\t\u0010]\u001a\u00020^H\u0096\u0001R\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\u0014\u001a\u00020\rX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0018\u0010\u001a\u001a\u00020\rX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0017\u00a8\u0006_"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$NativeBytes;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/memory/io/Allocation;", "Lorg/kodein/memory/io/KBuffer;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "buffer", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;Lorg/kodein/memory/io/KBuffer;)V", "available", "", "getAvailable", "()I", "getBuffer", "()Lorg/kodein/memory/io/KBuffer;", "capacity", "getCapacity", "limit", "getLimit", "setLimit", "(I)V", "offset", "getOffset", "position", "getPosition", "setPosition", "backingArray", "", "duplicate", "flip", "", "flush", "get", "", "index", "getByte", "getBytes", "dst", "dstOffset", "length", "getChar", "", "getDouble", "", "getFloat", "", "getInt", "getLong", "getShort", "", "internalBuffer", "newOffset", "putByte", "value", "putBytes", "src", "srcOffset", "Lorg/kodein/memory/io/Readable;", "putChar", "putDouble", "putFloat", "putInt", "putLong", "putShort", "readByte", "readBytes", "readChar", "readDouble", "readFloat", "readInt", "readLong", "readShort", "receive", "release", "reset", "set", "setByte", "setBytes", "Lorg/kodein/memory/io/ReadMemory;", "setChar", "setDouble", "setFloat", "setInt", "setLong", "setShort", "skip", "count", "slice", "toString", "", "valid", "", "kodein-leveldb_release"})
    private static final class NativeBytes
    extends NativeBound
    implements Allocation,
    KBuffer {
        @NotNull
        private final KBuffer buffer;

        @Override
        protected void release(long ptr) {
            Native.bufferRelease(ptr);
        }

        @NotNull
        public String toString() {
            return this.buffer.toString();
        }

        @NotNull
        public final KBuffer getBuffer() {
            return this.buffer;
        }

        public NativeBytes(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options, @NotNull KBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            super(ptr, "Value", handler, options);
            this.buffer = buffer;
        }

        public /* synthetic */ NativeBytes(long l, PlatformCloseable.Handler handler, LevelDB.Options options, KBuffer kBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                kBuffer = (KBuffer)KBufferJVMKt.wrap((KBuffer.Companion)KBuffer.Companion, (ByteBuffer)Native.bufferNew(l));
            }
            this(l, handler, options, kBuffer);
        }

        public int getAvailable() {
            return this.buffer.getAvailable();
        }

        public int getCapacity() {
            return this.buffer.getCapacity();
        }

        public int getLimit() {
            return this.buffer.getLimit();
        }

        public void setLimit(int n) {
            this.buffer.setLimit(n);
        }

        public int getOffset() {
            return this.buffer.getOffset();
        }

        public int getPosition() {
            return this.buffer.getPosition();
        }

        public void setPosition(int n) {
            this.buffer.setPosition(n);
        }

        @Nullable
        public byte[] backingArray() {
            return this.buffer.backingArray();
        }

        @NotNull
        public KBuffer duplicate() {
            return this.buffer.duplicate();
        }

        public void flip() {
            this.buffer.flip();
        }

        public void flush() {
            this.buffer.flush();
        }

        public byte get(int index) {
            return this.buffer.get(index);
        }

        public byte getByte(int index) {
            return this.buffer.getByte(index);
        }

        public void getBytes(int index, @NotNull byte[] dst, int dstOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            this.buffer.getBytes(index, dst, dstOffset, length);
        }

        public char getChar(int index) {
            return this.buffer.getChar(index);
        }

        public double getDouble(int index) {
            return this.buffer.getDouble(index);
        }

        public float getFloat(int index) {
            return this.buffer.getFloat(index);
        }

        public int getInt(int index) {
            return this.buffer.getInt(index);
        }

        public long getLong(int index) {
            return this.buffer.getLong(index);
        }

        public short getShort(int index) {
            return this.buffer.getShort(index);
        }

        @NotNull
        public KBuffer internalBuffer() {
            return this.buffer.internalBuffer();
        }

        public void offset(int newOffset) {
            this.buffer.offset(newOffset);
        }

        public void putByte(byte value) {
            this.buffer.putByte(value);
        }

        public void putBytes(@NotNull byte[] src, int srcOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.buffer.putBytes(src, srcOffset, length);
        }

        public void putBytes(@NotNull Readable src, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.buffer.putBytes(src, length);
        }

        public void putChar(char value) {
            this.buffer.putChar(value);
        }

        public void putDouble(double value) {
            this.buffer.putDouble(value);
        }

        public void putFloat(float value) {
            this.buffer.putFloat(value);
        }

        public void putInt(int value) {
            this.buffer.putInt(value);
        }

        public void putLong(long value) {
            this.buffer.putLong(value);
        }

        public void putShort(short value) {
            this.buffer.putShort(value);
        }

        public byte readByte() {
            return this.buffer.readByte();
        }

        public void readBytes(@NotNull byte[] dst, int dstOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            this.buffer.readBytes(dst, dstOffset, length);
        }

        public char readChar() {
            return this.buffer.readChar();
        }

        public double readDouble() {
            return this.buffer.readDouble();
        }

        public float readFloat() {
            return this.buffer.readFloat();
        }

        public int readInt() {
            return this.buffer.readInt();
        }

        public long readLong() {
            return this.buffer.readLong();
        }

        public short readShort() {
            return this.buffer.readShort();
        }

        public int receive() {
            return this.buffer.receive();
        }

        public int receive(@NotNull byte[] dst, int dstOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            return this.buffer.receive(dst, dstOffset, length);
        }

        public void reset() {
            this.buffer.reset();
        }

        public void set(int index, byte value) {
            this.buffer.set(index, value);
        }

        public void setByte(int index, byte value) {
            this.buffer.setByte(index, value);
        }

        public void setBytes(int index, @NotNull byte[] src, int srcOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.buffer.setBytes(index, src, srcOffset, length);
        }

        public void setBytes(int index, @NotNull ReadMemory src, int srcOffset, int length) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.buffer.setBytes(index, src, srcOffset, length);
        }

        public void setChar(int index, char value) {
            this.buffer.setChar(index, value);
        }

        public void setDouble(int index, double value) {
            this.buffer.setDouble(index, value);
        }

        public void setFloat(int index, float value) {
            this.buffer.setFloat(index, value);
        }

        public void setInt(int index, int value) {
            this.buffer.setInt(index, value);
        }

        public void setLong(int index, long value) {
            this.buffer.setLong(index, value);
        }

        public void setShort(int index, short value) {
            this.buffer.setShort(index, value);
        }

        public int skip(int count) {
            return this.buffer.skip(count);
        }

        @NotNull
        public KBuffer slice() {
            return this.buffer.slice();
        }

        @NotNull
        public KBuffer slice(int index, int length) {
            return this.buffer.slice(index, length);
        }

        public boolean valid() {
            return this.buffer.valid();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0014"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$WriteBatch;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$WriteBatch;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "append", "", "source", "clear", "delete", "key", "Lorg/kodein/memory/io/ReadMemory;", "put", "value", "release", "kodein-leveldb_release"})
    private static final class WriteBatch
    extends NativeBound
    implements LevelDB.WriteBatch {
        public void put(@NotNull ReadMemory key, @NotNull ReadMemory value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JvmNioKBuffer directKey = ReadBufferKt.directJvmNioKBuffer(key);
            JvmNioKBuffer directValue = ReadBufferKt.directJvmNioKBuffer(value);
            if (directKey != null && directValue != null) {
                Native.writeBatchPutBB(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), directValue.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directValue)), directValue.getAvailable());
            } else if (directValue != null) {
                Native.writeBatchPutAB(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), directValue.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directValue)), directValue.getAvailable());
            } else if (directKey != null) {
                Native.writeBatchPutBA(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable(), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), ReadMemoryKt.getSize((ReadMemory)value));
            } else {
                Native.writeBatchPutAA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key), ReadBufferKt.array(value), ReadBufferKt.arrayOffset(value), ReadMemoryKt.getSize((ReadMemory)value));
            }
        }

        public void delete(@NotNull ReadMemory key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JvmNioKBuffer directKey = ReadBufferKt.directJvmNioKBuffer(key);
            if (directKey != null) {
                Native.writeBatchDeleteB(this.getNonZeroPtr(), directKey.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directKey)), directKey.getAvailable());
            } else {
                Native.writeBatchDeleteA(this.getNonZeroPtr(), ReadBufferKt.array(key), ReadBufferKt.arrayOffset(key), ReadMemoryKt.getSize((ReadMemory)key));
            }
        }

        public void clear() {
            Native.writeBatchClear(this.getNonZeroPtr());
        }

        public void append(@NotNull LevelDB.WriteBatch source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Native.writeBatchAppend(this.getNonZeroPtr(), ((WriteBatch)source).getNonZeroPtr());
        }

        @Override
        protected void release(long ptr) {
            Native.writeBatchRelease(ptr);
        }

        public WriteBatch(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "WriteBatch", handler, options);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Snapshot;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "_dbPtr", "", "ptr", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JJLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "release", "", "kodein-leveldb_release"})
    private static final class Snapshot
    extends NativeBound
    implements LevelDB.Snapshot {
        private final long _dbPtr;

        @Override
        protected void release(long ptr) {
            Native.snapshotRelease(this._dbPtr, ptr);
        }

        public Snapshot(long _dbPtr, long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "Snapshot", handler, options);
            this._dbPtr = _dbPtr;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Cursor;", "Lorg/kodein/db/leveldb/jni/NativeBound;", "Lorg/kodein/db/leveldb/LevelDB$Cursor;", "ptr", "", "handler", "Lorg/kodein/db/leveldb/PlatformCloseable$Handler;", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "(JLorg/kodein/db/leveldb/PlatformCloseable$Handler;Lorg/kodein/db/leveldb/LevelDB$Options;)V", "keyBuffer", "Lorg/kodein/memory/io/JvmNioKBuffer;", "lens", "", "valueBuffer", "isValid", "", "next", "", "prev", "release", "seekTo", "target", "Lorg/kodein/memory/io/ReadMemory;", "seekToFirst", "seekToLast", "transientKey", "Lorg/kodein/memory/io/KBuffer;", "transientValue", "Companion", "kodein-leveldb_release"})
    private static final class Cursor
    extends NativeBound
    implements LevelDB.Cursor {
        private final int[] lens;
        private JvmNioKBuffer keyBuffer;
        private JvmNioKBuffer valueBuffer;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public boolean isValid() {
            return this.lens[0] >= 0;
        }

        public void seekToFirst() {
            Native.iteratorSeekToFirst(this.getNonZeroPtr(), this.lens);
        }

        public void seekToLast() {
            Native.iteratorSeekToLast(this.getNonZeroPtr(), this.lens);
        }

        public void seekTo(@NotNull ReadMemory target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            JvmNioKBuffer directTarget = ReadBufferKt.directJvmNioKBuffer(target);
            if (directTarget != null) {
                Native.iteratorSeekB(this.getNonZeroPtr(), directTarget.getByteBuffer(), KBufferKt.getAbsPosition((KBuffer)((KBuffer)directTarget)), directTarget.getAvailable(), this.lens);
            } else {
                Native.iteratorSeekA(this.getNonZeroPtr(), ReadBufferKt.array(target), ReadBufferKt.arrayOffset(target), ReadMemoryKt.getSize((ReadMemory)target), this.lens);
            }
        }

        public void next() {
            Native.iteratorNext(this.getNonZeroPtr(), this.lens);
        }

        public void prev() {
            Native.iteratorPrev(this.getNonZeroPtr(), this.lens);
        }

        @NotNull
        public KBuffer transientKey() {
            JvmNioKBuffer buffer;
            this.keyBuffer = buffer = Cursor.Companion.getBuffer(this.lens[0], this.keyBuffer);
            Native.iteratorKey(this.getNonZeroPtr(), buffer.getByteBuffer());
            return (KBuffer)buffer;
        }

        @NotNull
        public KBuffer transientValue() {
            JvmNioKBuffer buffer;
            this.valueBuffer = buffer = Cursor.Companion.getBuffer(this.lens[1], this.valueBuffer);
            Native.iteratorValue(this.getNonZeroPtr(), buffer.getByteBuffer());
            return (KBuffer)buffer;
        }

        @Override
        protected void release(long ptr) {
            Native.iteratorRelease(ptr);
        }

        public Cursor(long ptr, @NotNull PlatformCloseable.Handler handler, @NotNull LevelDB.Options options) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(ptr, "Cursor", handler, options);
            int n = 2;
            Cursor cursor = this;
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n2;
                int n5 = n2++;
                nArray = nArray2;
                boolean bl = false;
                nArray[n5] = n3 = -1;
            }
            nArray = nArray2;
            cursor.lens = nArray;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\b"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Cursor$Companion;", "", "()V", "getBuffer", "Lorg/kodein/memory/io/JvmNioKBuffer;", "len", "", "buffer", "kodein-leveldb_release"})
        public static final class Companion {
            private final JvmNioKBuffer getBuffer(int len, JvmNioKBuffer buffer) {
                JvmNioKBuffer jvmNioKBuffer;
                if (len < 0) {
                    throw (Throwable)new LevelDBException("Cursor is not valid");
                }
                if (buffer == null || buffer.getCapacity() < len) {
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect((len / 1024 + 2) * 1024);
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"ByteBuffer.allocateDirec\u2026(len / 1024) + 2) * 1024)");
                    jvmNioKBuffer = new JvmNioKBuffer(byteBuffer);
                } else {
                    jvmNioKBuffer = buffer;
                }
                JvmNioKBuffer realBuffer = jvmNioKBuffer;
                realBuffer.setLimit(len);
                return realBuffer;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/kodein/db/leveldb/jni/LevelDBJNI$Companion;", "", "()V", "newNativeOptions", "", "options", "Lorg/kodein/db/leveldb/LevelDB$Options;", "snapshotPtr", "snapshot", "Lorg/kodein/db/leveldb/LevelDB$Snapshot;", "kodein-leveldb_release"})
    public static final class Companion {
        private final long newNativeOptions(LevelDB.Options options) {
            return Native.optionsNew(options.getPrintLogs(), options.getOpenPolicy().getCreateIfMissing(), options.getOpenPolicy().getErrorIfExists(), options.getParanoidChecks(), options.getWriteBufferSize(), options.getMaxOpenFiles(), options.getCacheSize(), options.getBlockSize(), options.getBlockRestartInterval(), options.getMaxFileSize(), options.getSnappyCompression(), options.getReuseLogs(), options.getBloomFilterBitsPerKey());
        }

        private final long snapshotPtr(LevelDB.Snapshot snapshot) {
            return snapshot != null ? ((Snapshot)snapshot).getNonZeroPtr() : 0L;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

