/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bybit.service;

import io.github.resilience4j.ratelimiter.RateLimiter;
import java.io.IOException;
import org.knowm.xchange.bybit.BybitAdapters;
import org.knowm.xchange.bybit.BybitExchange;
import org.knowm.xchange.bybit.dto.BybitCategory;
import org.knowm.xchange.bybit.dto.BybitResult;
import org.knowm.xchange.bybit.dto.account.BybitAccountInfoResponse;
import org.knowm.xchange.bybit.dto.account.allcoins.BybitAllCoinsBalance;
import org.knowm.xchange.bybit.dto.account.feerates.BybitFeeRates;
import org.knowm.xchange.bybit.dto.account.position.BybitSetLeveragePayload;
import org.knowm.xchange.bybit.dto.account.position.BybitSwitchModePayload;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitAccountType;
import org.knowm.xchange.bybit.dto.account.walletbalance.BybitWalletBalance;
import org.knowm.xchange.bybit.service.BybitBaseService;
import org.knowm.xchange.client.ResilienceRegistries;

public class BybitAccountServiceRaw
extends BybitBaseService {
    protected BybitAccountServiceRaw(BybitExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    BybitResult<BybitWalletBalance> getWalletBalances(BybitAccountType accountType) throws IOException {
        BybitResult<BybitWalletBalance> walletBalances = this.bybitAuthenticated.getWalletBalance(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), accountType.name());
        if (!walletBalances.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(walletBalances);
        }
        return walletBalances;
    }

    BybitResult<BybitAllCoinsBalance> getAllCoinsBalance(BybitAccountType accountType) throws IOException {
        BybitResult<BybitAllCoinsBalance> allCoinsBalance = this.bybitAuthenticated.getAllCoinsBalance(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), accountType.name());
        if (!allCoinsBalance.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(allCoinsBalance);
        }
        return allCoinsBalance;
    }

    BybitResult<BybitFeeRates> getFeeRatesRaw(BybitCategory category, String symbol) throws IOException {
        BybitResult<BybitFeeRates> bybitFeeRatesResult = this.bybitAuthenticated.getFeeRate(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), category.getValue(), symbol);
        if (!bybitFeeRatesResult.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(bybitFeeRatesResult);
        }
        return bybitFeeRatesResult;
    }

    BybitResult<Object> setLeverageRaw(BybitCategory category, String symbol, double leverage) throws IOException {
        String leverageString = Double.toString(leverage);
        BybitSetLeveragePayload payload = new BybitSetLeveragePayload(category.getValue(), symbol, leverageString, leverageString);
        RateLimiter rateLimiter = null;
        switch (category) {
            case INVERSE: {
                rateLimiter = this.rateLimiter("positionSetLeverageInverse");
                break;
            }
            case LINEAR: {
                rateLimiter = this.rateLimiter("positionSetLeverageLinear");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only Linear and Inverse category");
            }
        }
        BybitResult setLeverageResult = (BybitResult)this.decorateApiCall(() -> this.bybitAuthenticated.setLeverage(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload)).withRateLimiter(rateLimiter).withRateLimiter(this.rateLimiter("global")).call();
        if (!setLeverageResult.isSuccess() && setLeverageResult.getRetCode() != 110043) {
            throw BybitAdapters.createBybitExceptionFromResult(setLeverageResult);
        }
        return setLeverageResult;
    }

    BybitResult<Object> switchPositionModeRaw(BybitCategory category, String symbol, String coin, int mode) throws IOException {
        BybitSwitchModePayload payload = new BybitSwitchModePayload(category.getValue(), symbol, coin, mode);
        BybitResult<Object> switchModeResult = this.bybitAuthenticated.switchMode(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory(), payload);
        if (!switchModeResult.isSuccess() && switchModeResult.getRetCode() != 110025) {
            throw BybitAdapters.createBybitExceptionFromResult(switchModeResult);
        }
        return switchModeResult;
    }

    BybitResult<BybitAccountInfoResponse> accountInfoRaw() throws IOException {
        BybitResult<BybitAccountInfoResponse> accountInfo = this.bybitAuthenticated.getAccountInfo(this.apiKey, this.signatureCreator, ((BybitExchange)this.exchange).getTimeStampFactory());
        if (!accountInfo.isSuccess()) {
            throw BybitAdapters.createBybitExceptionFromResult(accountInfo);
        }
        return accountInfo;
    }
}

