/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.knopflerfish.service.log.LogRef;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public final class SendUserAdminEventJob
implements Runnable {
    LogRef log;
    BundleContext bc;
    ServiceTracker eventAdminTracker;
    UserAdminEvent event;
    Vector listeners;
    static final String basePath = "org/osgi/service/useradmin/UserAdmin/";

    SendUserAdminEventJob(BundleContext bc, ServiceTracker eventAdminTracker, UserAdminEvent event, Vector listeners) {
        this.bc = bc;
        this.eventAdminTracker = eventAdminTracker;
        this.event = event;
        this.listeners = (Vector)listeners.clone();
        this.log = new LogRef(bc);
    }

    String getEventAdminPath() {
        String evtType = "?";
        switch (this.event.getType()) {
            case 1: {
                evtType = "ROLE_CREATED";
                break;
            }
            case 2: {
                evtType = "ROLE_CHANGED";
                break;
            }
            case 4: {
                evtType = "ROLE_REMOVED";
            }
        }
        return basePath + evtType;
    }

    void put(Hashtable dict, String key, Object val) {
        if (null != val) {
            dict.put(key, val);
        }
    }

    Event getEvent() {
        String path = this.getEventAdminPath();
        Hashtable dict = new Hashtable();
        this.put(dict, "event.topics", path);
        this.put(dict, "event", this.event);
        this.put(dict, "timestamp", new Long(System.currentTimeMillis()));
        this.put(dict, "role", this.event.getRole());
        this.put(dict, "role.name", this.event.getRole().getName());
        this.put(dict, "role.type", new Integer(this.event.getRole().getType()));
        this.put(dict, "service", this.event.getServiceReference());
        this.put(dict, "service.id", this.event.getServiceReference().getProperty("service.id"));
        this.put(dict, "service.objectClass", this.event.getServiceReference().getProperty("objectClass"));
        this.put(dict, "service.pid", this.event.getServiceReference().getProperty("service.pid"));
        return new Event(path, dict);
    }

    public void run() {
        EventAdmin ea = (EventAdmin)this.eventAdminTracker.getService();
        if (null != ea) {
            ea.postEvent(this.getEvent());
        }
        Enumeration en = this.listeners.elements();
        while (en.hasMoreElements()) {
            ServiceReference sr = (ServiceReference)en.nextElement();
            UserAdminListener ual = (UserAdminListener)this.bc.getService(sr);
            if (ual != null) {
                try {
                    ual.roleChanged(this.event);
                }
                catch (Throwable t) {
                    this.log.error("[UserAdmin] Error while sending roleChanged event to" + sr, t);
                }
            }
            this.bc.ungetService(sr);
        }
    }
}

