/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Vector;
import org.knopflerfish.service.um.useradmin.Condition;
import org.knopflerfish.service.um.useradmin.impl.Activator;
import org.knopflerfish.service.um.useradmin.impl.LDAPQuery;
import org.knopflerfish.service.um.useradmin.impl.RoleImpl;
import org.knopflerfish.service.um.useradmin.impl.UserAdminImpl;
import org.osgi.framework.InvalidSyntaxException;

public class ConditionImpl
extends RoleImpl
implements Condition {
    private static final SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat time_format = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat day_format = new SimpleDateFormat("EEEE");
    protected String filter;

    ConditionImpl(String name) {
        super(name);
    }

    boolean hasMember(String user, Dictionary context, Vector v) {
        if (this.filter == null) {
            return true;
        }
        if (context != null) {
            long now = System.currentTimeMillis();
            context.put("date", date_format.format(new Long(now)).toString());
            context.put("time", time_format.format(new Long(now)).toString());
            context.put("day", day_format.format(new Long(now)).toString());
            try {
                return LDAPQuery.query(this.filter, context);
            }
            catch (InvalidSyntaxException e) {
                Activator.log.error("Bad LDAP syntax: " + this.filter);
            }
        }
        return false;
    }

    public int getType() {
        return -1;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(UserAdminImpl.adminPermission);
        }
        this.filter = filter;
    }
}

