/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.text.SimpleDateFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.knopflerfish.service.um.ipam.IPAMValuationService;
import org.knopflerfish.service.um.ipam.Levels;
import org.knopflerfish.service.um.useradmin.ContextualAuthorization;
import org.knopflerfish.service.um.useradmin.impl.Activator;
import org.knopflerfish.service.um.useradmin.impl.RoleImpl;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.Role;

public class AuthorizationImpl
implements ContextualAuthorization {
    private static final String CONTEXT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String CONTEXT_TIME_FORMAT = "HH:mm:ss";
    private static final String CONTEXT_DAY_FORMAT = "EEEE";
    protected RoleImpl user;
    protected Dictionary context;
    static /* synthetic */ Class class$org$knopflerfish$service$um$ipam$IPAMValuationService;

    AuthorizationImpl(RoleImpl user) {
        this.user = user;
        this.context = new Hashtable();
        long now = System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat(CONTEXT_DATE_FORMAT);
        this.context.put("auth_date", format.format(new Long(now)).toString());
        format = new SimpleDateFormat(CONTEXT_TIME_FORMAT);
        this.context.put("auth_time", format.format(new Long(now)).toString());
        format = new SimpleDateFormat(CONTEXT_DAY_FORMAT);
        this.context.put("auth_day", format.format(new Long(now)).toString());
    }

    public String getName() {
        if (this.user.getName().equals("user.anyone")) {
            return null;
        }
        return this.user.getName();
    }

    public boolean hasRole(String roleName) {
        return this.user.hasRole(roleName, this.user.getName(), this.context, new Vector());
    }

    public String[] getRoles() {
        Vector<String> result = new Vector<String>();
        try {
            Role[] roles = Activator.uai.getRoles(null);
            for (int i = 0; i < roles.length; ++i) {
                String roleName = roles[i].getName();
                if (!this.hasRole(roleName) || "user.anyone".equals(roleName)) continue;
                result.addElement(roleName);
            }
        }
        catch (InvalidSyntaxException ex) {
            // empty catch block
        }
        if (result.size() == 0) {
            return null;
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public void setIPAMContext(String inputPath, String authMethod) {
        int authLevel = 0;
        int confLevel = 0;
        int integrLevel = 0;
        ServiceReference ipamsr = Activator.bc.getServiceReference((class$org$knopflerfish$service$um$ipam$IPAMValuationService == null ? (class$org$knopflerfish$service$um$ipam$IPAMValuationService = AuthorizationImpl.class$("org.knopflerfish.service.um.ipam.IPAMValuationService")) : class$org$knopflerfish$service$um$ipam$IPAMValuationService).getName());
        if (ipamsr != null) {
            IPAMValuationService ipam = (IPAMValuationService)Activator.bc.getService(ipamsr);
            if (ipam != null) {
                Levels levels = ipam.getLevels(inputPath, authMethod);
                authLevel = levels.getAuthLevel();
                confLevel = levels.getConfLevel();
                integrLevel = levels.getIntegrLevel();
            } else if (Activator.log.doWarn()) {
                Activator.log.warn("IPAM service is not available. Using fallback IPAM context");
            }
            Activator.bc.ungetService(ipamsr);
        } else if (Activator.log.doWarn()) {
            Activator.log.warn("IPAM service is not available. Using fallback IPAM context");
        }
        this.context.put("auth_lvl", new Integer(authLevel));
        this.context.put("conf_lvl", new Integer(confLevel));
        this.context.put("integr_lvl", new Integer(integrLevel));
    }

    public Dictionary getContext() {
        return this.context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

